//
//  UIColor+AUToken.h
//  111
//
//  Created by 胡胡超 on 2022/4/21.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN
@protocol AUTokenDynamicColorProtocol <NSObject>

@optional
/// 这方法其实是 iOS 13 新增的 UIDynamicColor 里的私有方法，只要任意 UIColor 的类实现这个方法并返回 YES，就能自动响应 iOS 13 下的 UIUserInterfaceStyle 的切换，这里在 protocol 里声明是为了方便 .m 里调用（否则会因为不存在的 selector 而无法编译）
@property(nonatomic, assign, readonly) BOOL _isDynamic;

@end
@interface UIColor (AUToken)<AUTokenDynamicColorProtocol>
///标志当前 UIColor 对象是否为动态颜色（或者 iOS 13 下由 [UIColor colorWithDynamicProvider:]、[UIColor initWithDynamicProvider:] 创建的颜色）
@property(nonatomic, assign, readonly) BOOL aut_isDynamicColor;
@property(nonatomic, assign, readonly) BOOL aut_colorIsDark;
///获取在暗黑模式下实际静态颜色
@property(nonatomic, strong, readonly) UIColor *aut_realDrakColor;
///获取在亮白模式下实际静态颜色
@property(nonatomic, strong, readonly) UIColor *aut_realLightColor;
/// 获取当前 color 的实际静态颜色
///referView：传入你要使用获取静态颜色Color的View。
///1.referView为空，根据app设置的模式进行返回
///2.referView不为空，根据referView的模式进行返回.比如APP设置为了暗黑、某一些页面设置亮白
@property(nonatomic, copy, readonly) UIColor *(^aut_realColor)(UIView* referView);
/// 获取当前CG color 的实际静态颜色
///referView：传入你要使用获取静态颜色Color的View。
///1.referView为空，根据app设置的模式进行返回
///2.referView不为空，根据referView的模式进行返回.比如APP设置为了暗黑、某一些页面设置亮白
@property(nonatomic, copy, readonly) CGColorRef (^aut_realCGColor)(UIView* referView);

+ (UIColor *)auToken_colorWithToken:(NSString*)token defaultColor:(UIColor *)color;



/// if是以“COLOR_”开头，就用token方式进行读取，没有返回nil
/// else 根据str 到colormap找对应暗黑色，将2个组装成动态color返回，未匹配到用str生成一个静态color返回
/// @param str COLOR_BRAND1 #FFFFFF #FF000000
+(nullable UIColor *)auTokenMatchColorMap_colorWithTokenOrHexStr:(NSString *)str;
+(UIColor *)auTokenMatchColorMap_colorWithRed:(CGFloat)r green:(CGFloat)g blue:(CGFloat)b alpha:(CGFloat)a;
@end



@interface UIColor (AUToken_Utils)
///生成2个颜色的中间色
///渐变百分比percent 0-1, 从color1->color2
+ (nullable UIColor *)auToken_colorOfPercent:(CGFloat)percent between:(UIColor *)color1 and:(UIColor *)color2;
+ (nullable UIColor *)auToken_colorWithHexString:(nullable NSString *)hexString;

@end

NS_ASSUME_NONNULL_END
