//
//  AUTokenManager.h
//  111
//
//  Created by 胡胡超 on 2022/4/19.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
//主题切换（亮白/暗黑）
#define kAUDidChangeThemeNotificationName @"kAUDidChangeThemeNotificationName"

typedef NS_ENUM(NSInteger, AUUserInterfaceStyle) {
    AUUserInterfaceStyleSystem, //跟随系统
    AUUserInterfaceStyleLight,       //亮白
    AUUserInterfaceStyleDark,        //暗黑
};
NS_ASSUME_NONNULL_BEGIN
@class AUTokenManager;
@protocol AUTokenManagerDataSource <NSObject>
//@{@"COLOR_BACKGROUND":@{@"normal":@"#999999",@"dark":@"#999999"},
//  @"SIZE_RADIUS_S":@{@"normal":@(400),@"old":@(400)}};
///返回自定义token值
-(NSDictionary *)tokenManagerGetCustomToken:(AUTokenManager*)manager;
///获取自定义颜色映射表， 原始color --> 替换color
-(NSDictionary *)tokenManagerGetColorMaps:(AUTokenManager*)manager;
///返回当前放大比例
-(CGFloat)tokenManagerGetCurrentScalingRatio:(AUTokenManager*)manager;
///返回一个window，SDK内部会以这个window的亮白/暗黑作为全局当前模式
///建议返回，AppDelegate中创建window。默认：[UIApplication sharedApplication].keyWindow
-(UIWindow*)tokenManagerGetKeyWindow:(AUTokenManager*)manager;

///暗黑模式进行vc级别控制，在viewDidLoad中，进行处理
///1.命中黑名单vc.overrideUserInterfaceStyle = UIUserInterfaceStyleLight (优先级高，用于回滚)
///2.命中白名单 vc.overrideUserInterfaceStyle = UIUserInterfaceStyleUnspecified
///3.默认UIUserInterfaceStyleLight
///返回类名字符串
-(NSArray<NSString *>*)tokenManagerGetControllerWhiteList:(AUTokenManager*)manager;
-(NSArray<NSString *>*)tokenManagerGetControllerBlackList:(AUTokenManager*)manager;

///暗黑模式进行往window上添加view进行控制
///  { systemList:[ @“ClassName”]，不进行处理
///   bList:[  ]，  设置UIUserInterfaceStyleLight
///   wList:[  ] ,   根据当前vc设置overrideUserInterfaceStyle
/// }
///   未命中UIUserInterfaceStyleLight
///   优先级从上到下
-(NSDictionary*)tokenManagerGetViewList:(AUTokenManager*)manager;
-(UIViewController*)tokenManagerGetCurrentVC:(AUTokenManager*)manager;

-(void)tokenManagerLogStr:(NSString*)logstr;

@end

@interface AUTokenManager : NSObject

@property(weak,nonatomic)id<AUTokenManagerDataSource> delegate;

+ (AUTokenManager *)shared;
///初始化enable是否开始暗黑模式
+(void)initDarkModeEnable:(BOOL)enable;
///是否已经初始
+(BOOL)isInitialization;
///暗黑SDK是否可用
+(BOOL)isDarkModeEnable;
//返回支持设置模式
//iOS13以及以上返回@[@(AUUserInterfaceStyleSystem),@(AUUserInterfaceStyleLight),@(AUUserInterfaceStyleDark)]
//iOS13以下返回@[]
+(NSArray<NSNumber *> *)supportInterfaceStyles;
//设置模式
+ (BOOL)setInterfaceStyle:(AUUserInterfaceStyle)interfaceStyle;
//获取当时设置模式
+ (AUUserInterfaceStyle)currentInterfaceStyle;
//是否是全局暗黑
+ (BOOL)isDarkMode;
//当前vc的暗黑,如果没拿到vc，返回NO
+ (BOOL)isCurrentVCDarkMode;
//当前vc的是否支持暗黑,如果没拿到vc，返回NO
+ (BOOL)isCurrentVCSupportDarkMode;
//获取vc的是否支持暗黑
+(BOOL)isSupportDarkModeWithVC:(Class)vcClass;
//获取vc是否暗黑
+(BOOL)isDarkModeWithVC:(Class)vcClass;


/*** 获取token*/
//亮白colors
+(NSDictionary *)getNormalColorTokens;
//当前colors
+(NSDictionary *)getCurrentColorTokens;
// 获取颜色映射表， 原始color --> 替换color
+(NSDictionary *)getColorMaps;

//打开调试工具。会在window，添加一个切换模式的View
+(void)openDarkModeDebugTool;

@end

NS_ASSUME_NONNULL_END
