//
//  AUToken.h
//  111
//
//  Created by 胡胡超 on 2022/4/21.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <AUToken/AUTokenManager.h>
#import <AUToken/UIView+AUTokenUpdater.h>
#import <AUToken/UIImage+AUToken.h>
#import <AUToken/UIColor+AUToken.h>
#import <AUToken/UIViewController+AUToken.h>

//! Project version number for ModuleName.
FOUNDATION_EXPORT double AUTokenVersionNumber;

//! Project version string for ModuleName.
FOUNDATION_EXPORT const unsigned char AUTokenVersionString[];

NS_ASSUME_NONNULL_BEGIN
@interface AUToken : NSObject
// 主题色
///支付宝品牌色（元素) {@"normal":@"#1677FF",@"dark":@"#3086FF",@"priority":@(1)}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_BRAND1;
///支付宝品牌色（大面积背景）{@"normal":@"#1677FF",@"dark":@"#093066"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_BRAND2;

// 辅助色
///黄色 {@"normal":@"#FF9F18",@"dark":@"#FFA930"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_YELLOW;
///绿色 {@"normal":@"#22B35E",@"dark":@"#34B368"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_GREEN;
///红色 {@"normal":@"#FF3141",@"dark":@"#FF4A58"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_RED;
///橙色{@"normal":@"#FF6430",@"dark":@"#E65A2B"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_ORANGE;
///深蓝色（链接）{@"normal":@"#4B6B99",@"dark":@"#3F5980"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_LINK;
///浅蓝色  {@"normal":@"#E7F1FF",@"dark":@"#0D2543"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_WATHET;

// 中性色
///白色
@property (nonatomic,strong,class,readonly) UIColor *COLOR_WHITE;
///黑色 {@"normal":@"#000000",@"dark":@"#000000"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_BLACK;
///主信息 {@"normal":@"#333333",@"dark":@"#E6E6E6"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_TEXT_PRIMARY;
///副信息 {@"normal":@"#666666",@"dark":@"#B3B3B3"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_TEXT_SECONDARY;
///辅助信息 {@"normal":@"#999999",@"dark":@"#808080"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_TEXT_ASSIST;
///弱信息 {@"normal":@"#CCCCCC",@"dark":@"#4D4D4D"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_TEXT_WEAK;
///分割线 {@"normal":@"#EEEEEE",@"dark":@"#2B2B2B"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_BORDER;
///全局背景 {@"normal":@"#F5F5F5",@"dark":@"#0A0A0A"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_BACKGROUND;
///卡片 {@"normal":@"#FFFFFF",@"dark":@"#1A1A1A",@"priority":@(1)}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_CARD;
///负反馈卡片 {@"normal":@"#FFFFFF",@"dark":@"#2A2A2A"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_CARD2;
///白色动态  {@"normal":@"#FFFFFF",@"dark":@"#FFFFFF"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_WHITE_CHANGE;
///黑色动态 {@"normal":@"#000000",@"dark":@"#000000"}
@property (nonatomic,strong,class,readonly) UIColor *COLOR_BLACK_CHANGE;
///自定义color 支持（NSString *）0XFFFFFF、#FFFFFF、FFFFFF、FFFFFF
///         支持  UIColor
@property (nonatomic,copy,class,readonly) UIColor * (^CustomToken)(id lColor,id dColor);

//@{@"normal":@(4),@"old":@(4)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_RADIUS_S;
//{@"normal":@(8),@"old":@(8)
@property (nonatomic,assign,class,readonly) CGFloat SIZE_RADIUS_M;
//@{@"normal":@(12),@"old":@(12)
@property (nonatomic,assign,class,readonly) CGFloat SIZE_RADIUS_L;

//{@"normal":@(2),@"old":@(3)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_SPACE1;
//{@"normal":@(4),@"old":@(6)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_SPACE2;
//{@"normal":@(6),@"old":@(9)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_SPACE3;
//{@"normal":@(8),@"old":@(12)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_SPACE4;
//{@"normal":@(10),@"old":@(15)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_SPACE5;
//{@"normal":@(12),@"old":@(18)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_SPACE6;
//{@"normal":@(14),@"old":@(21)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_SPACE7;
//{@"normal":@(16),@"old":@(24)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_SPACE8;
//{@"normal":@(18),@"old":@(27)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_SPACE9;
//{@"normal":@(20),@"old":@(30)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_SPACE10;

//{@"normal":@(11),@"old":@(16)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_FONT1;
//{@"normal":@(12),@"old":@(16)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_FONT2;
//{@"normal":@(13),@"old":@(18)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_FONT3;
//{@"normal":@(14),@"old":@(18)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_FONT4;
//{@"normal":@(15),@"old":@(18)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_FONT5;
//{@"normal":@(16),@"old":@(20)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_FONT6;
//{@"normal":@(17),@"old":@(20)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_FONT7;
//{@"normal":@(18),@"old":@(24)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_FONT8;
//{@"normal":@(20),@"old":@(24)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_FONT9;
//{@"normal":@(24),@"old":@(28)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_FONT10;
//{@"normal":@(28),@"old":@(32)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_FONT11;
//{@"normal":@(32),@"old":@(36)}
@property (nonatomic,assign,class,readonly) CGFloat SIZE_FONT12;
//自定义size
@property (nonatomic,copy,class,readonly) CGFloat (^CustomSize)(CGFloat normal,CGFloat old);
//根据token取size，如找token，就用defaultNormal，defaultOld
@property (nonatomic,copy,class,readonly) CGFloat (^getSizeToken)(NSString* sizeToken,CGFloat defaultNormal,CGFloat defaultOld);
@end

@interface UIColor (AUToken_Opacity)
//8%
@property (nonatomic,strong,readonly) UIColor *PRESS;
//40%
@property (nonatomic,strong,readonly) UIColor *DISABLE;
//55%
@property (nonatomic,strong,readonly) UIColor *MASK;
//90%
@property (nonatomic,strong,readonly) UIColor *MODULE;
@end

//叠加黑色-暗黑模式、叠加白色-正常模式
//叠加的背景色必须是非透明的
@interface UIColor (AUToken_OverlayColor)
//8%叠加白色-暗黑模式、叠加黑色-正常模式
@property (nonatomic,strong,readonly) UIColor *OVERLAY_PRESS;
//40%叠加黑色-暗黑模式、叠加白色-正常模式
@property (nonatomic,strong,readonly) UIColor *OVERLAY_DISABLE;
//55%叠加黑色-暗黑模式、叠加白色-正常模式
@property (nonatomic,strong,readonly) UIColor *OVERLAY_MASK;
//90%叠加黑色-暗黑模式、叠加白色-正常模式
@property (nonatomic,strong,readonly) UIColor *OVERLAY_MODULE;
@end
NS_ASSUME_NONNULL_END
