
#import <AUTheme/AUTheme.h>

//
@interface UIView (AUTheme)

#define AU_COLOR(key)           [self au_colorForKey:key]
#define AU_FONT(key)            [self au_fontForKey:key]
#define AU_ICONSIZE(key)        [self au_iconSizeForKey:key]
#define AU_SPACE(key)           [self au_spaceForKey:key]
#define AU_CORNERRADIUS(key)    [self au_cornerRadiusForKey:key]
#define AU_IAMGE_NAME(key)      [self au_imageNameForKey:key]

@property (nonatomic, strong) AUTheme *auTheme;

/**AUTheme
 获取Theme中key对应的颜色值

 @param key theme中的key
 @return 颜色值
 */
- (UIColor *)au_colorForKey:(NSString *)key;

/**
 获取Theme中key对应的字体

 @param key them e中的key
 @return 字体
 */
- (UIFont *)au_fontForKey:(NSString *)key;

/**
 获取Theme中key对应的图标的大小

 @param key theme中的key
 @return icon的size
 */
- (CGSize)au_iconSizeForKey:(NSString *)key;

/**
 获取Theme中key对应的间距

 @param key theme中的key
 @return 间距
 */
- (CGFloat)au_spaceForKey:(NSString *)key;


/**
 获取Theme中key对应的圆角大小

 @param key theme中的key
 @return 圆角大小
 */
- (CGFloat)au_cornerRadiusForKey:(NSString *)key;

/**
 获取Theme中key对应的图标名字
 
 @param key theme中的key
 @return 圆角大小
 */
- (NSString *)au_imageNameForKey:(NSString *)key;

@end




