//
//  AUNumbericDependency.h
//  AUKeyboard
//
//  Created by Wang on 2020/8/20.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AUKeyboard/AUNumKeyboards.h>
NS_ASSUME_NONNULL_BEGIN




@interface AUNumericDependency : NSObject

//@property (nonatomic,weak) UIWindow *baseKeyWindow;

-(void) setBaseKeyWindow:(UIWindow * _Nullable)baseKeyWindow;

//View
//1px的值，默认1/[Screen
-(CGFloat) onePixelLine;

//安全区域的大小
-(UIEdgeInsets) safeAreaInsets;

// i18n
-(NSString *)i18n:(NSString*)bundle identifier:(NSString *)identifier defaultValue:(NSString *)defaultValue;

// 屏幕宽度
-(CGFloat) screenWidth;

// 无论横屏还是竖屏，都返回竖屏时的屏幕高度
-(CGFloat) screenHeightForPortrait;


// Font
// 返回显示的字体
-(UIFont *) fontName:(NSString *)fontName size:(CGFloat)size;

// 数字字体名字
-(NSString *) numericFontName;

//Image
// 36px * 36px, 0x333333;
// 向下的箭头
-(UIImage *) downArrowImage;

//[UIImage iconWithName_au:kICONFONT_TEXTDELETE width:iconWidth color:RGB(0x333333)];
//回退键的Image
-(UIImage *) backspaceImage:(CGFloat) iconWidth;

//[UIImage iconWithName_au:kICONFONT_TEXTDELETE width:iconWidth color:AUButtonGetHighlightedForeColor(RGB(0x333333))];
//高亮时候的回退键
-(UIImage *) highlightedBackspaceImage:(CGFloat) iconWidth;

//根据Color返回UIImage
-(UIImage *) imageWithColor1x1_au:(UIColor *)color;

//Color

//根据普通色，返回高亮时的背景色
-(UIColor *) AUButtonGetHighlightedBackColor:(UIColor *)color;

//根据普通色，返回高亮时的前景色
-(UIColor *) AUButtonGetHighlightedForeColor:(UIColor *)color;

//根据普通色，返回禁用时的前景色
-(UIColor *) AUButtonGetDisableColor:(UIColor*)color;

//Logger
//日志
-(void) remoteLogging:(NSString *) moduleName exInfo:(NSArray*)array;

//Config
//开关
-(NSString *)configForKey:(NSString *)key;

@end



AUNumericDependency *AUNumericDependencyGet();


NS_ASSUME_NONNULL_END
