//
//  AUMarsNativeShell.h
//  AUBase
//
//  Created by niki on 2022/4/29.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@protocol MarsViewModelProtocal <NSObject>

@property (nonatomic, strong) NSString* rootPath;       //资源根目录
@property (nonatomic, strong) NSData* binData;          //资源内容(playground使用)
@property (nonatomic, strong) NSString *version;        //1.0
@property (nonatomic, assign) CGFloat duration;
@property (nonatomic, strong) NSDictionary *params;     //other？
@property (nonatomic, assign) BOOL animationLoop;       //定义loop行为;

@end

@interface AUMarsNativeShell : NSObject

+ (instancetype _Nullable)marsNativeWithModel:(id<MarsViewModelProtocal>)model
                                     complete:(void(^_Nullable)(BOOL success, NSString *_Nullable err, UIView *marsNativeView)) completion;

+ (BOOL)isSupportWithVersion:(NSString *)version;

+ (BOOL)isSupportCompressedTextureWithMarsView:(UIView *)marsView;

+ (void)setupMarsNativeView:(UIView *)marsView
                 imageDatas:(NSDictionary<NSString *, NSData *> *)imageData
                 completion:(void(^)(BOOL success))completion;

+ (BOOL)isMarsNative:(NSObject *)object;

+ (BOOL)isSupportWebpWithMarsView:(UIView *)marsView;

@end


BOOL AUBIsKindOfMarsNative(NSObject *o) __attribute__((weak));

NS_ASSUME_NONNULL_END
