//
//  AUBFoundation.h
//  AUBase
//
//  Created by Wang on 2021/3/11.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN


/**
 * DTExtensions for reading value for key
 * @see NSUserDefaults
 */
@interface NSDictionary (AUBFoundation)

/* C */
- (float)floatForKey_ap:(id)aKey;
- (float)floatForKey_ap:(id)aKey defaultValue:(float)defaultValue;
- (double)doubleForKey_ap:(id)aKey;
- (double)doubleForKey_ap:(id)aKey defaultValue:(double)defaultValue;
/* C More */
- (long long)longLongForKey_ap:(id)aKey;
- (unsigned long long)unsignedLongLongForKey_ap:(id)aKey;

/* OC */
- (BOOL)boolForKey_ap:(id)aKey;
- (BOOL)boolForKey_ap:(id)aKey defaultValue:(BOOL)defaultValue;
- (NSInteger)integerForKey_ap:(id)aKey;
- (NSInteger)integerOrNotFoundForKey_ap:(id)aKey;
- (NSInteger)integerForKey_ap:(id)aKey defaultValue:(NSInteger)defaultValue;

/* OC More */
- (NSUInteger)unsignedIntegerForKey_ap:(id)aKey;
- (NSUInteger)unsignedIntegerOrNotFoundForKey_ap:(id)aKey;
- (NSUInteger)unsignedIntegerForKey_ap:(id)aKey defaultValue:(NSUInteger)defaultValue;

/* OC Object */
- (NSNumber *)numberForKey_ap:(id)aKey;
- (NSNumber *)numberForKey_ap:(id)aKey defaultValue:(NSNumber *)defaultValue;
- (NSString *)stringForKey_ap:(id)aKey;
- (NSString *)stringOrEmptyStringForKey_ap:(id)akey;
- (NSString *)stringForKey_ap:(id)akey defaultValue:(NSString *)defaultValue;
- (NSArray *)arrayForKey_ap:(id)aKey;
- (NSArray *)arrayForKey_ap:(id)aKey defaultValue:(NSArray *)defaultValue;
- (NSDictionary *)dictionaryForKey_ap:(id)aKey;
- (NSDictionary *)dictionaryForKey_ap:(id)aKey defaultValue:(NSDictionary *)defaultValue;
- (NSData *)dataForKey_ap:(id)aKey;
- (NSData *)dataForKey_ap:(id)aKey defaultValue:(NSData *)defaultValue;
- (NSDate *)dateForKey_ap:(id)aKey;
- (NSDate *)dateForKey_ap:(id)aKey defaultValue:(NSDate *)defaultValue;
- (NSURL *)URLForKey_ap:(id)aKey;
- (NSURL *)URLForKey_ap:(id)aKey defaultValue:(NSURL *)defaultValue;

/* OC Object More */
- (id)objectForKey_ap:(id)aKey class:(Class)theClass;
- (id)objectForKey_ap:(id)aKey class:(Class)theClass defaultValue:(id)defaultValue;
- (id)objectForKey_ap:(id)aKey protocol:(Protocol *)protocol;
- (id)objectForKey_ap:(id)aKey protocol:(Protocol *)protocol defaultValue:(id)defaultValue;
- (id)objectForKey_ap:(id)aKey class:(Class)theClass protocol:(Protocol *)protocol;
- (id)objectForKey_ap:(id)aKey class:(Class)theClass protocol:(Protocol *)protocol defaultValue:(id)defaultValue;



@end


/**
 * DTExtensions for writing value for key
 */
@interface NSMutableDictionary (AUBFoundation)

/* C */
- (void)setFloat_ap:(float)value forKey:(id<NSCopying>)aKey;
- (void)setDouble_ap:(double)value forKey:(id<NSCopying>)aKey;

/* C More */
- (void)setLongLong_ap:(long long)value forKey:(id<NSCopying>)aKey;
- (void)setUnsignedLongLong_ap:(unsigned long long)value forKey:(id<NSCopying>)aKey;

/* OC */
- (void)setBool_ap:(BOOL)value forKey:(id<NSCopying>)aKey;
- (void)setInteger_ap:(NSInteger)value forKey:(id<NSCopying>)aKey;

/* OC More */
- (void)setUnsignedInteger_ap:(NSUInteger)value forKey:(id<NSCopying>)aKey;

/* OC Object */
- (void)setObjectOrNil_ap:(id)anObject forKey:(id<NSCopying>)aKey;

/**
 *  @brief 给可变字典设置对象，如果对象为nil，直接返回不修改原始数据
 *
 *  @param anObject obj
 *  @param aKey     key
 */
- (void)setSafeObject_ap:(id)anObject forKey:(id<NSCopying>)aKey;



@end
NS_ASSUME_NONNULL_END
