//
//  NSUserDefaults+APStorageCenter.h
//  APStorageCenter
//
//  Created by SUOMAN on 2021/8/25.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// NSUserDefaults 接口包装
/// 获取指定 bundle 下的 KV，不传入 bundle 代表当前调用方
/// 返回 nil 代表无权限

@interface NSUserDefaults (APStorageCenter)

- (nullable id)objectForKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (void)setObject:(nullable id)value forKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (void)removeObjectForKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (nullable NSString *)stringForKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (nullable NSArray *)arrayForKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (nullable NSDictionary<NSString *, id> *)dictionaryForKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (nullable NSData *)dataForKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (nullable NSArray<NSString *> *)stringArrayForKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (NSInteger)integerForKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (float)floatForKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (double)doubleForKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (BOOL)boolForKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (nullable NSURL *)URLForKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (void)setInteger:(NSInteger)value forKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (void)setFloat:(float)value forKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (void)setDouble:(double)value forKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (void)setBool:(BOOL)value forKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

- (void)setURL:(nullable NSURL *)url forKey:(NSString *)defaultName bundle:(nullable NSString *)bundle;

@end

NS_ASSUME_NONNULL_END
