//
//  APStorageMonitorService.h
//  APStorageCenter
//
//  Created by kongzhaoyang on 2021/8/20.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <APMobileFramework/DTService.h>

NS_ASSUME_NONNULL_BEGIN

/// 业务枚举
typedef NS_ENUM(NSInteger, APStorageMonitorBizName) {
    APStorageMonitorBizCCDN,         // CCDN
    APStorageMonitorBizMultimedia,   // 多媒体
};

/// 管理资源的方式
typedef NS_ENUM(NSInteger, APStorageMonitorIDType) {
    APStorageMonitorIDAppID,         // AppID
    APStorageMonitorIDBiz,           // Biz
};


@interface APStorageMonitorBizInfo : NSObject

@property(nonatomic, assign) APStorageMonitorBizName bizName;   // 业务名称（必需）
@property(nonatomic, assign) APStorageMonitorIDType IDType;     // ID类型（必需）
@property(nonatomic, copy) NSString *IDName;                     // ID名称（必需）
@property(nonatomic, assign) NSUInteger dirSize;                 // 目录大小（可选）
@property(nonatomic, assign) NSTimeInterval downloadTime;        // 下载时间（可选）
@property(nonatomic, assign) NSTimeInterval accessTime;          // 访问时间（内部属性，不需要传参）

- (instancetype)initWithBizName:(APStorageMonitorBizName)bizName
                         IDType:(APStorageMonitorIDType)IDType
                         IDName:(NSString *)IDName;

@end


@interface APStorageMonitorService : NSObject <DTService>

@property (nonatomic, copy, readonly) NSArray *configurations;  // 内部属性
@property (nonatomic, copy, readonly) NSArray *directorys;      // 内部属性
@property (nonatomic, copy, readonly) NSArray *limitDirectorys; // 内部属性

/**
 * 读取文件事件采集
 *
 * filePath 读取文件的绝对路径
 */
- (void)monitorReadingWithFilePath:(NSString *)filePath;

/**
 * 修改文件事件采集
 *
 * filePath 读取文件的绝对路径
 */
- (void)monitorWritingWithFilePath:(NSString *)filePath;

/**
 * 读取文件事件采集
 *
 * filePath 读取文件的绝对路径
 * params 业务需要透传的参数，执行失败时上报埋点携带
 */
- (void)monitorReadingWithFilePath:(NSString *)filePath params:(NSDictionary *)params;

/**
 * 修改文件事件采集
 *
 * filePath 读取文件的绝对路径
 * params 业务需要透传的参数，执行失败时上报埋点携带
 */
- (void)monitorWritingWithFilePath:(NSString *)filePath params:(NSDictionary *)params;


/**
 * 读取DB目录内的文件事件采集
 *
 * path BD文件的上一级目录绝对路径
 */
- (void)monitorReadingWithDBPath:(NSString *)path;

/**
 * 修改DB目录内的文件事件采集
 *
 * path BD文件的上一级目录绝对路径
 */
- (void)monitorWritingWithDBPath:(NSString *)path;

/**
 * 监控资源使用
 *
 * bizInfo 业务信息
 */
- (void)monitorResourceOperationWithBizInfo:(APStorageMonitorBizInfo *)bizInfo;

/**
 * 删除资源监控记录
 *
 * bizInfo 业务信息
 */
- (void)removeRecordWithBizInfo:(APStorageMonitorBizInfo *)bizInfo;


/********** 辅助功能 ***********/

/**
 * 计算目录大小，递归计算所有文件
 *
 * path 目录的绝对路径
 */
- (unsigned long long)folderSizeAtPath:(NSString *)path;


/********** 内部功能，外部不要调用 ***********/

- (NSString *)cleanerNameWithDirectory:(NSString *)directory;
- (NSString *)businessWithDirectory:(NSString *)directory;
@end

NS_ASSUME_NONNULL_END
