//
//  APStorageCleanDelegate.h
//  APStorageCenter
//
//  Created by kongzhaoyang on 2021/8/20.
//  Copyright © 2021 Alipay. All rights reserved.
//

#ifndef APStorageCleanDelegate_h
#define APStorageCleanDelegate_h

#import <Foundation/Foundation.h>
#import "APStorageMonitorService.h"

typedef NS_ENUM(NSUInteger, APStorageCleanPolicy) {
    APStorageCleanPolicyNone = 0,                   // 不执行任何操作
    APStorageCleanPolicyRemove,                     // 执行删除操作
};

@class APStorageCleanContext;

@protocol APStorageCleanDelegate <NSObject>

/**
 * 存储巡检警告，建议执行自动清理，提供参考信息
 * 巡检本身没有删除任何数据，警告业务自己执行删除操作
 *
 * context 当前环境需要清理的目录、存储率，建议删除的文件列表等信息
 * context.cleanWarningType
 * APStorageCleanWarningTypeSupersize 目录超大异常，可用信息directoryPath，directorySize
 * APStorageCleanWarningTypeRateLow 目录存储使用率低，可用信息directoryPath，directorySize，accessRate，cleanFiles
 * APStorageCleanWarningTypeOversize 业务超过配额，可用信息businessName, businessSize，如果接入了精细化管控，则可用sortedIdentifiers
 *
 * decisionHandler 执行操作后通知存储中心再进行监测，如果没有任何操作，则不进行监测
 */
- (void)autoCleanWithContext:(APStorageCleanContext *)context decisionHandler:(void (^)(APStorageCleanPolicy))decisionHandler;

/**
 * 返回当前自行管理资源标识的排序，排序越后面的越早删除
 */
- (NSArray <APStorageMonitorBizInfo *>*)sortedIdentifiersWithContext:(APStorageCleanContext *)context;

/**
 * 用户手动清理，需要删除该目录下的所有文件
 */
+ (void)manualClean;

/**
 * 计算用户可手动清理的目录大小
 */
+ (unsigned long long)purgeableCacheSize;

@end

#endif /* APStorageCleanDelegate_h */
