//
//  APPathUtilities.h
//  APStorageCenter
//
//  Created by SUOMAN on 2021/8/24.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APSCPublicHeaders.h"

NS_ASSUME_NONNULL_BEGIN

/// 获取 bundle 沙箱根目录
/// @param bundle 不传入，代表当前调用方 bundle (框架根据调用堆栈自动解析)
/// @return nil 代表无权限访问
NSString *APHomeDirectoryInBundle(NSString * _Nullable bundle);
NSString *APHomeDirectory(void);

/// 获取 bundle 沙箱二级目录
/// @param bundle 不传入，代表当前调用方 bundle (框架根据调用堆栈自动解析)
/// @param categoryPath 二级目录分类
/// @return nil 代表无权限访问
NSString *APSearchPathForDirectoriesInBundle(NSString * _Nullable bundle, APBundleSandBoxCategoryPath categoryPath);
NSString *APSearchPathForDirectories(APBundleSandBoxCategoryPath categoryPath);

NS_ASSUME_NONNULL_END
