//
//  IEvelopeCryptoModule.h
//  APSecSecuritySDK
//
//  Created by hongren on 2022/3/17.
//  Copyright © 2022 Alipay. All rights reserved.
//

#ifndef IEvelopeCryptoModule_h
#define IEvelopeCryptoModule_h

#import "ITrustedModule.h"
#import "EvelopeCryptoDefines.h"

@protocol IEvelopeCryptoModule <ITrustedModule>

@required
- (EvelopeCryptoResult *) encrypt: (NSData*) plainData
                           params: (EvelopeCryptoParams* ) cryptoParams;

@required
- (EvelopeCryptoResult *) encrypt: (NSData*) plainData
                           bizkey: (NSString*) bizKey
                           params: (EvelopeCryptoParams* ) cryptoParams;

@required
- (EvelopeCryptoResult *) decrypt: (NSData*) cipherData
                           params: (EvelopeCryptoParams*) cryptoParams;

@required
- (EvelopeCryptoResult *) decrypt: (NSData*) cipherData
                           bizkey: (NSString*) bizKey
                           params: (EvelopeCryptoParams*) cryptoParams;

@end





#endif /* IEvelopeCryptoModule_h */
