//
//  ImageCache2.h
//  APMultimedia
//
//  Created by Cloud on 16/8/30.
//  Copyright © 2016年 Alipay. All rights reserved.
//


#import "ImageCacheOptions.h"
#import <APMMediaCache/APMMediaCache.h>

#define kPhotoMaxSize  1280

@interface ImageInfo2 : NSObject

@property (nonatomic, assign) int width;
@property (nonatomic, assign) int height;
@property (nonatomic, assign) ImageInternalType type;
@property (nonatomic, assign) ImageCropMode cropMode;
/**
 是否是动态图
 */
@property (nonatomic, assign) BOOL animated;


- (NSString *)encode;
- (void)decode:(NSString *)info;

@end

@interface ImageCache2 : FileCache2

- (void)setObject:(NSObject *)object forKey:(NSString *)key type:(ImageInternalType)type size:(CGSize)size options:(ImageCacheOptions *)options;
- (NSObject *)objectForKey:(NSString *)key type:(ImageInternalType)type size:(CGSize)size options:(ImageCacheOptions *)options includePhotoLibrary:(BOOL)includePHLibrary waitForiCloud:(BOOL)waitForiCloud;
- (NSObject *)objectForKey:(NSString *)key type:(ImageInternalType)type size:(CGSize)size options:(ImageCacheOptions *)options;
- (NSString *)generatePathForKey:(NSString *)key type:(ImageInternalType)type size:(CGSize)size;
- (NSString *)objectPathForKey:(NSString *)key type:(ImageInternalType)type size:(CGSize)size options:(ImageCacheOptions *)options;

- (NSString *)generateMemoryKeyFromKey:(NSString *)key type:(ImageInternalType)type size:(CGSize)size options:(ImageCacheOptions *)options;


- (UIImage *)proceedImage:(UIImage *)image type:(ImageInternalType)type size:(CGSize)size options:(ImageCacheOptions *)options;
- (NSObject *)responseWithObject:(NSObject *)object repsonseType:(ImageResponseType)responseType;


@end
