//
//  FLAnimatedImageView.h
//  Flipboard
//
//  Created by Raphael Schaad on 7/8/13.
//  Copyright (c) 2013-2015 Flipboard. All rights reserved.
//


#import <UIKit/UIKit.h>
#import "APImageRequest.h"
//
//  An `FLAnimatedImageView` can take an `FLAnimatedImage` and plays it automatically when in view hierarchy and stops when removed.
//  The animation can also be controlled with the `UIImageView` methods `-start/stop/isAnimating`.
//  It is a fully compatible `UIImageView` subclass and can be used as a drop-in component to work with existing code paths expecting to display a `UIImage`.
//  Under the hood it uses a `CADisplayLink` for playback, which can be inspected with `currentFrame` & `currentFrameIndex`.
//
@interface APAnimatedImageView : UIImageView

@property (nonatomic, strong, readonly) UIImage *currentFrame;

@property (nonatomic, assign, readonly) NSUInteger currentFrameIndex;

// The animation runloop mode. Enables playback during scrolling by allowing timer events (i.e. animation) with NSRunLoopCommonModes.
// To keep scrolling smooth on single-core devices such as iPhone 3GS/4 and iPod Touch 4th gen, the default run loop mode is NSDefaultRunLoopMode. Otherwise, the default is NSRunLoopCommonModes.
@property (nonatomic, copy) NSString *runLoopMode;

@property (nonatomic, assign) NSUInteger loopCount;

@property (nonatomic, copy) void(^loopCompletionBlock)(NSUInteger loopCountRemaining);


/**
 是否由上层完全控制动画的播放和停止。默认为NO，由view自行控制，view不显示的时候自动停止播放。
 */
@property (nonatomic, assign) BOOL manualControlAnimated;

//startAnimating和stopAnimating在设置图片的内容之前调用不产生效果
- (void)startAnimating;
- (void)stopAnimating;

/**
 设置gif data

 @param gifData gif二进制数据
 */
- (void)setGifData:(NSData *)gifData DEPRECATED_MSG_ATTRIBUTE("use [setGifData:withBizType:] instead");
- (void)setGifData:(NSData *)gifData withBizType:(NSString *)bizType;
- (void)setGifData:(NSData *)gifData withBizType:(NSString *)bizType posterImage:(UIImage *)posterImage;

/**
 设置UIAnimationImage,UIAnimationImage是系统提供的gif image对象

 @param animationImage UIAnimationImage 对象
 */
- (void)setUIAnimationImage:(UIImage *)animationImage DEPRECATED_MSG_ATTRIBUTE("use [setUIAnimationImage:withBizType:] instead");

- (void)setUIAnimationImage:(UIImage *)animationImage withBizType:(NSString *)bizType;

/// 判断是否是动图，当前支持的动图包括GIF，AHP3
/// @param image 待判断的image
+ (BOOL)isAnimatedImage:(UIImage *)image;

/**
 通过设置url或者id来设置展示的animateView，接口内部会设置view的image信息，千万不要在request的downloadComplete中设置view的image属性

 @param key urlh或者cloud id
 @param request 请求参数
 */
- (void)setImageWithKey:(NSString *)key
                request:(APImageRequest*)request;

@end
