//
//  LBSmPaaSAdaptor.h
//  APMobileLBS
//
//  Created by 去疾 on 17/2/28.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APMapService.h"
#import <APMobileLBS/APMapService.h>

typedef void(^mapReGeocodeCompletedBlock)(NSDictionary *result, NSError *error);

@protocol AriverMapEngineDelegate <NSObject>
@optional

-(void)mPaaSReverseWithLocation:(APMapReGeoRequest*)reGeoRequest completion:(mapReGeocodeCompletedBlock)completion;

@end

@interface LBSmPaaSAdaptor : NSObject

@property (nonatomic, assign) BOOL  shouldSkipLBSLocation; // 是否不需要 LBS 定位服务

@property (nonatomic, assign) BOOL  shouldAMapRegeoWhenLBSFailed; // 默认为NO，LBS服务获取mPaaS逆地理失败时，是否再调用高德逆地理接口获取一次
@property (nonatomic, assign) BOOL  shouldUseAMapRegeoDirectly; // 默认为NO，直接使用高德逆地理接口，此标识设置后会忽略上面 shouldAMapRegeoWhenLBSFailed

@property (nonatomic, assign) BOOL  needCheckIn; // 是否打开签到功能

@property(nonatomic, weak) id<AriverMapEngineDelegate> ariverMapEngineDelegate;

+ (instancetype)sharedInstance;

+(id<APMapService>) getMapService;

+(NSString*) getCurrentAppId;

+(NSString*) getStringValueFromConfigService:(NSString*)key;

+(BOOL) isCoverInstall;

@end
