//
//  APMAnimationGenerator.h
//  APMediaBasic
//
//  Created by 鲁旭 on 2020/10/29.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
typedef NS_ENUM(NSInteger, APMAnimationFormatType){
    APMAnimationFormatGIF,
    APMAnimationFormatAPNG
};

@interface APMAnimationGenerator : NSObject
//生成动图格式
@property (nonatomic, assign)APMAnimationFormatType format;
//生成动图帧间延迟
@property (nonatomic, assign)CGFloat delayTime;

//合成的动图
@property (nonatomic, strong, readonly)UIImage *animation;
//合成的data
@property (nonatomic, strong, readonly) NSMutableData *data;

-(void)prepareWithCount:(NSUInteger)count;

-(void)addImage:(UIImage *)image;

-(void)finish;

@end

NS_ASSUME_NONNULL_END
