//
//  APMapCommonMapMarker.h
//  APMap
//
//  Created by 去疾 on 17/3/28.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
#import <APMap/APMapCommonMapCallout.h>
#import "APMapCommonMapLabel.h"

@interface APMapCommonMapMarker : MAAnimatedAnnotation
@property (nonatomic,strong) NSNumber *identifier;
@property (nonatomic,copy) NSString *identifierStr;
@property (nonatomic,assign) CLLocationDegrees latitude;
@property (nonatomic,assign) CLLocationDegrees longitude;

//@property (nonatomic,strong) NSString * title;
//@property (nonatomic,strong) NSString * subtitle;

@property (nonatomic,strong) UIImage * icon;
@property (nonatomic,strong) NSData * iconData;
@property (nonatomic,strong) NSString * iconAppendStr;
@property (nonatomic,strong) UIColor * iconAppendStrColor;

@property (nonatomic,strong) NSDictionary *styleDic;

@property (nonatomic,assign) CGFloat rotate;
@property (nonatomic,assign) CGFloat alpha;
@property (nonatomic,assign) CGFloat width;
@property (nonatomic,assign) CGFloat height;

@property (nonatomic,assign) CGFloat anchorX;
@property (nonatomic,assign) CGFloat anchorY;

@property (nonatomic,strong) UIImage * imageForAnnotation;
@property (nonatomic,strong) UIImage *style4Image;
@property (nonatomic,strong) UIView *animationViewForAnnotaion;
 
@property (nonatomic,strong) APMapCommonMapCallout * callout;

@property (nonatomic,assign) NSInteger markerLevel;

@property (nonatomic,assign) BOOL isCustomCallout;
@property (nonatomic,assign) NSInteger customCalloutType;
@property (nonatomic,strong) NSString * customCalloutTime;
@property (nonatomic,assign) BOOL customCalloutShouldShow;
@property (nonatomic,assign) BOOL canShowOnTap;
@property (nonatomic,strong) NSArray *descList;
@property (nonatomic,strong) NSArray *subDescList;
@property (nonatomic,strong) NSArray *displayRanges;
@property (nonatomic,copy) NSString *bottomDescString;
@property (nonatomic,strong) APMapCommonMapLabel *labelModel;
@property (nonatomic,assign) BOOL clusterEnabled;
@property (nonatomic,assign) BOOL animateMarker;

@property (nonatomic,assign) CLLocationDirection mapRotationDegree;

-(id)initWithLongitude:(CLLocationDegrees)longitude latitude:(CLLocationDegrees)latitude andIcon:(UIImage*)icon;

-(void)prepareForAnnotation;

- (void)prepareAnimationAnnotationWithData:(NSDictionary *)data;

- (UIImage *)getImageWithStyle4Data:(NSDictionary *)data;

- (void)updateAnimationAnnotationWithImage:(UIImage *)image;

- (void)updateDescLabelWithString:(NSString *)string;
//
//-(BOOL)getMarkerRotateModeWithConfigService;

@end
