//
//  MediaCache.h
//  APMultimedia
//
//  Created by 慎一 on 2016/12/23.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <APMCache/APMCache.h>
#import "FileCache2.h"


@interface TempMediaInfo : NSObject

@property(nonatomic, assign) long long startOffset;

@property(nonatomic, assign) long long fileLength;

@property (nonatomic, copy) NSString *contentType;

@property (nonatomic, assign) BOOL supportRangeAccess;

@property (nonatomic, assign) int recordTime;

@property (nonatomic, copy) NSString *business;

@property (nonatomic, copy) NSString *path;


- (NSString *)encode;

- (void)decode:(NSString *)info;

@end


@interface MediaCache : FileCache2

- (TempMediaInfo *)mediaInfoWithKey:(NSString *)key;

- (BOOL)setObjectWithPath:(NSString *)filePath WithKey:(NSString *)key mediaInfo:(TempMediaInfo *)mediaInfo;

- (NSString *)cacheKeyWithCloudId:(NSString *)cloudId;
- (NSString *)cacheKeyWithEncryptCloudId:(NSString *)cloudId;
@end
