//
//  UIImage+HEVC.h
//  APMultimedia
//
//  Created by 慎一 on 2017/5/15.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface UIImage (HEVC)

/**
 @param defColorSpace 设置图片colorspace：1 - HEVC default colorspace
                                        0 - BT601 colorspace.
 @param defAhpOpt     设置是否开启图片性能优化: 1 - 开启
                                           0 - 关闭
 */
+ (UIImage *)apm_imageWithHevcData:(NSData *)data defColorSpace:(int) defColorSpace defAhpOpt:(int) defAhpOpt;

+ (unsigned long)apm_currentAHPVersion;

/**
 是否是AHP编码的图片数据
 
 @param imageData 待判断的image data
 @return 是否是AHP编码的图片数据
 */
+ (BOOL)apm_isHEVCImageData:(NSData *)imageData;


/*****************************************************************************/
/*                                                                           */
/* Decode and convert HEVC/RGB/RGBA image to AYUV.                           */
/*                                                                           */
/*****************************************************************************/
/**
 转码HEVC图片为AYUV格式.
 
 @param data - HEVC图片数据.
 */
+ (NSData *)apm_AYUVWithHevcData:(NSData *)data;

/**
 转码RGB数据为AYUV格式.
 
 @param img_w    - RGB图片宽.
 @param img_h    - RGB图片高.
 @param img_data - RGB图片数据.
 @param haveAlpha           - 有Alpha通道.
 @param isAlphaFirst        - Alpha通道数据在第一位.
 @param isLittleByteOrder   - 是小端模式，否则为大段.
 */
+(NSData *)apm_AYUVWithRGBA:(int) img_w img_h:(int) img_h img_data:(unsigned char *) img_data haveAlpha:(int) haveAlpha isAlphaFirst:(int) isAlphaFirst isLittleByteOrder:(int) isLittleByteOrder;

@end
