//
//  NetworkSetting.h
//  APMultimedia
//
//  Created by 慎一 on 2018/4/24.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>


typedef enum : NSUInteger {
    APMCloud_Upload,
    APMCloud_Download
} APMCloud_UpDownNetEnum;


@interface NetworkSetting : NSObject
/**
 *  使用massProxy上传时，超时时间
 */
@property (nonatomic, assign) NSUInteger timeout4Upload;
/**
 * 使用massProxy上传时，最大超时时间
 */
@property (nonatomic, assign) NSUInteger maxTimeout4Upload;
/**
 *  使用massProxy下载时，超时时间
 */
@property (nonatomic, assign) NSUInteger timeout4Download;
/**
 * 是否使用ping来做盘路验证
 */
@property (nonatomic, assign) BOOL enablePing;
/**
 * 网络不好时，用ping做旁路验证时主机地址
 */
@property (nonatomic, copy) NSString *pingHost;
/**
 * 网络不好时，多久处理一次带宽不足事件.单位秒
 */
@property (nonatomic, assign) NSUInteger period4HandleLowBandwidth;
/**
 * 网络不好时，ping做旁路验证时，ping包的次数
 */
@property (nonatomic, assign) NSUInteger countOfPing;
/**
 * 主播推流，拥塞阀值,单位KB
 */
@property (nonatomic, assign) NSUInteger maxSendBufferSize;
/**
 * 直播主播方底层多久采集一次带宽数据,单位秒
 */
@property (nonatomic, assign) NSUInteger period4BandwidthSample;
/**
 * 主播推流拥塞恢复最大累计次数，超过则认为恢复
 */
@property (nonatomic, assign) NSUInteger maxCongestionResumeEventCount;
/**
 *  部分外链图片下载，默认UA会返回403，需要修改为合适的UA
 */
@property (nonatomic, copy) NSString *userAgent;
/**
 *  9.0以下版本reachability用方法SCNetworkReachabilityCreateWithName，hostName可由该字段配置，默认www.baidu.com
 */
@property (nonatomic, copy) NSString *host4Reachability;
/**
 * PHAsset对应的图片资源不在本地，需要从iCloud下载时，避免每次下载原图，可以设置一个最大边去下载一个清晰度和流量取得平衡的图片。
 * 0表示targetSize为PHImageManagerMaximumSize
 * 默认最大边为1280，单位是像素
 */
@property (nonatomic, assign) NSUInteger maxWidthForiCloudDownloading;
/**
 * AFHTTPRequestSerializer中是用NSLocale还是NSBundle类来构造accept-language,ios10中使用nslocale存在crash，所以替换为nsbundle了。
 */
@property (nonatomic, assign) BOOL useNSBundle;
/**
 * 是否使用网络组件提供的弱网模型，默认YES
 */
@property (nonatomic, assign) BOOL useWeakNetworkModel;
/**
 * 弱网判断标准，只使用QOS_LEVEL_D作为标准，默认NO
 * 当前是QOS_LEVEL_C和QOS_LEVEL_D作为弱网
 */
@property (nonatomic,assign) BOOL onlyUseDAsWeakNetwork;
/**
 * 上传图片是否并发，默认是
 */
@property (nonatomic,assign) BOOL uploadImageConcurrently;
/**
 *  同步iCloud资源，超时时间
 */
@property (nonatomic, assign) int timeout4iCloudSync;
/**
 *  通道切换配置的business,会根据配置决定走大数据通道与否
 */
@property (nonatomic, strong) NSArray* uploadBusTypeArray;
@property (nonatomic, strong) NSArray* downloadBusTypeArray;
@property (nonatomic, copy) NSArray *aftsCDNDownloadBizTypeArray;

/**
 * DJango图片最大并发下载数，默认4（网络组件django最大并发4）
 */
@property (nonatomic, assign) NSUInteger maxDjangoDlConcurrentCount;
/**
 * 白名单Url图片最大并发下载数,默认5（网络组件url最大并发8）
 */
@property (nonatomic, assign) NSUInteger maxUrlDlConcurrentCount;
/**
 * 非白名单Url图片最大并发下载数,默认3（网络组件url最大并发8）
 */
@property (nonatomic, assign) NSUInteger maxBlackUrlDlConcurrentCount;

/**
 *  **下载**是否默认走https，默认值为NO
 */
@property (nonatomic, assign) BOOL useHttpsByDefault;
/**
 * url下载域名白名单
 */
@property (nonatomic, strong) NSArray* urlDomainWhiteList;


@property (nonatomic, assign) BOOL generateAftsFileUrlForAftsResource;


@property (nonatomic, copy) NSString *configUniquiKey;

@property (nonatomic, assign) BOOL usingDispatchCallbackQueue;

@property (nonatomic, assign) BOOL usingStaticTraceId;

@property (nonatomic, assign) BOOL usingH5Cache;




/**
 *  共享对象
 *
 *  @return 共享的对象
 */
+ (instancetype)sharedInstance;

- (instancetype)init __attribute__((unavailable("init not available")));


/**
 *  根据business决定是否走大数据通道
 *
 *  @param business
 *
 *  @return YES：NO
 */
- (BOOL)isMMTCChannelOpenWithBusiType:(NSString*)business Action:(APMCloud_UpDownNetEnum)Action;

- (BOOL)isAftsCDNChannelOpenWithBizType:(NSString*)bizType;

#pragma mark -  无网络错误
- (BOOL)shouldReturnErrorImmediatelyWhenNetworkUnreachableWithBizType:(NSString*)bizType;

- (NSError *)unreachableNetworkError;

@end
