//
//  APMVirtualProgress.h
//  APMultimedia
//
//  Created by Monster on 16/7/19.
//  Copyright © 2016年 Alipay. All rights reserved.
//
//  假进度依赖于任务管理，每次在规定的时间间隔内取0-4区间的随机数增长至规定的最大区间内的随机数
//  假进度在有真进度进来且大于当前假进度值时，假进度作废

#import <Foundation/Foundation.h>

@interface APMVirtualProgress : NSObject

@property (nonatomic, readonly) double curPercentage;               //当前百分比进度
@property (nonatomic, strong) APMMProcessiveBlock processiveBlock;    //假进度处理block

/**
 *  创建假进度处理生成对象
 *
 *  @param increaseTimeInterval          进度增长时间间隙  默认:500ms
 *  @param maxValueRange                 进度增长到的最大值范围 默认10-12
 *
 *  @return APMVirtualProgress
 */
+ (instancetype)createWithIncreaseTimeInterval:(NSTimeInterval)increaseTimeInterval maxValueRange:(NSRange)maxValueRange;


/**
 *  开始假进度动作
 */
- (void)startVirtualProgress;


/**
 *  结束假进度动作
 */
- (void)finishVirtualProgress;
@end

