//
//  APMFileUploadResponse.h
//  APMFileTransfer
//
//  Created by Kris Tian on 2019/7/23.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@class APMUploadResponse;


typedef void (^APMStartUploadBlock)(NSString *key,
                                    NSData *data);

typedef void (^APMUploadResponseCompletion)(APMUploadResponse *response);

//进度回调
typedef void (^APMProcessiveBlock)(double percentage,
                                   long long partialBytes,
                                   long long totalBytes);

@interface APMUploadResponse : NSObject

/**
 上传生成的服务器端id
 */
@property (nonatomic, copy) NSString *cloudId;

/**
 上传失败的错误码
 */
@property (nonatomic, strong) NSError *error;

/**
 服务器端返回的一些额外信息，在上传的extraHeaders和extraParams为不为空的情况下，extraInfo可能返回一些有效信息。由业务方和服务器端约定。
 */
@property (nonatomic, copy) NSDictionary *extraInfo;


- (instancetype)initWithError:(NSError *)error;

- (instancetype)initWithCloudId:(NSString *)cloudId;

- (instancetype)initWithCloudId:(NSString *)cloudId error:(NSError *)error extraInfo:(NSDictionary *)extraInfo;

@end

