//
//  APBaseUploadRequest.h
//  APMFileTransfer
//
//  Created by 鲁旭 on 2020/4/13.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <APMCommon/APMConst.h>
#import "APBaseRequest.h"

NS_ASSUME_NONNULL_BEGIN

@interface APBaseUploadRequest : APBaseRequest

/**
 上传时额外的http头部参数，需要业务方和服务器端协商
 */
@property (nonatomic, copy) NSDictionary<NSString *,NSString *> *extraHeaders;

/**
 需要业务方和服务器端协商, 额外的上传参数，非头部
 如非必要，请不要用私有资源，例如社交场景带隐私的文件。
 私有资源不走cdn加速，直接走源站，量大会导致效率低，而且对源站造成风险。
 使用公有资源示例：request.extraParams = @{@"setpublic":@"true"};
 */
@property (nonatomic, copy) NSDictionary<NSString *,NSString *> *extraParams;

/**
 上传的进度回调，可选项
 */
@property (nonatomic, copy) APMMProcessiveBlock progress;


/**
 上传操作的超时时间，默认时间120s
 */
@property (nonatomic, assign) NSTimeInterval timeout4Upload;

- (BOOL)requiredMMTC;

- (BOOL)canUseCachedCloudId;


@end

NS_ASSUME_NONNULL_END
