//
//  APFileManager+Private.h
//  APMultimedia
//
//  Created by 慎一 on 2017/11/22.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import "APFileManager.h"

typedef NS_ENUM(NSUInteger, APFileDownloadStatus) {
    APFileDownloadStatusWaiting = 0,                  //等待执行
    APFileDownloadStatusRunning = 1,                  //正在执行
    APFileDownloadStatusCancel = 2,                   //取消执行
    APFileDownloadStatusFail = 3,                     //执行失败
    APFileDownloadStatusSuccess = 4,                  //执行成功
    APFileDownloadStatusNotFound = 5,                 //任务不存在
};

typedef NS_ENUM(NSUInteger, APFileCacheStatus) {
    APFileCacheStatusNoCache = 0,
    APFileCacheStatusPartialCacheExist = 1,
    APFileCacheStatusCacheExist = 2,
};

@interface APFileManager (Private)

-(APFileDownloadRequest*)brokenPointContinuinglyTransferringDownloadRequestWithCloudId:(NSString *)cloudId;

- (NSString *)resumeBreakpointDownloadFile:(NSString *)cloudId
                                       url:(NSString *)url
                                   bizType:(NSString *)bizType
                                  progress:(APMMProcessiveBlock)progress
                                completion:(APFileDownloadRequestComplete)complete;

/**
 /获取下载任务的状态，是给付费音频项目使用，外层封装了jsapi，未对外暴露

 @param identifier 下载的cloudid 或者url
 @param request 下载请求
 @return task状态
 */
- (APFileDownloadStatus)getDownloadStatusOfFile:(NSString *)identifier request:(APFileDownloadRequest *)request;

/**
 查询cache状体

 @param identifier 下载的cloudid 或者url
 @return 缓存状态
 */
- (APFileCacheStatus)getCacheStatusOfFile:(NSString *)identifier;


@end
