//
//  UnavailableCheckManager.h
//  APMultimedia
//
//  Created by Monster on 15/10/27.
//  Copyright © 2015年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>


/* --------------|------------------------------------------------------------------
 * 采集不可用:0    |  不可录音:0     不可拍照:1      不可录像:2
 * --------------|------------------------------------------------------------------
 * 压缩不可用:1    |  图片不可压缩:0  视频不可压缩:1   语音不可压缩:2
 * --------------|------------------------------------------------------------------
 * 网络上传不可用:2 |  一定时段内没上传成功过:0
 * --------------|------------------------------------------------------------------
 * 网络下载不可用:3 |  一定时段内没下载成功过:0
 * --------------|------------------------------------------------------------------
 * 播放不可用:4    |  语音播放失败:0   视频播放失败:1
 * --------------|------------------------------------------------------------------
 * 数据解码不可用:5 |  图片解码不可用:0   语音silk转wav不可用:1  视频播放解码不可用:2
 * --------------|------------------------------------------------------------------
 */

typedef enum : NSUInteger {
// 采集不可用
    Unavailable_AudioRecord,
    Unavailable_Picture,
    Unavailable_VideoRecord,
// 压缩不可用
    Unavailable_ImageCompress,
    Unavailable_VideoCompress,
    Unavailable_AudioCompress,
// 上传
    Unavailable_UrlUpload,
// 下载
    Unavailable_UrlDownload = 9,
// 播放
    Unavailable_AudioPlay = 12,
    Unavailable_VideoPlay,
// 解压缩
    Unavailable_ImageUnCompress = 15,
    Unavailable_AudioUncompress,
    Unavailable_VideoUncompress,
// 切换cache目录
    Unavailable_CacheFolderChange = 19,
} APMMUnavailable_CheckType;


#define UnavailableCheckUrlDownloadSubTypeDownloadFile  @"DownloadFile"
#define UnavailableCheckUrlDownloadSubTypeDownloadiCloudImage   @"DownloadiCloudImage"
#define UnavailableCheckUrlDownloadSubTypeDownloadImage   @"DownloadImage"
#define UnavailableCheckUrlDownloadSubTypeDownloadVoice   @"DownloadVoice"
#define UnavailableCheckUrlDownloadSubTypeDownloadVideo   @"DownloadVideo"
#define UnavailableCheckUrlDownloadSubTypeAddWaterMarkImage   @"AddWaterMarkImage"
#define UnavailableCheckUrlDownloadSubTypeGenerateWaterMark   @"GenerateWaterMark"
#define UnavailableCheckUrlDownloadSubTypeReadVideoData   @"ReadVideoData"



@interface UnavailableCheckManager : NSObject

+ (void)fucUnavailableType:(APMMUnavailable_CheckType)type failCode:(NSUInteger)failCode subType:(NSString *)subType params:(NSArray *)params;
@end
