//
//  NSString+Format.h
//  APMultimedia
//
//  Created by 慎一 on 16/9/30.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSString (APMFormat)

- (BOOL)apm_isBse64EncodedString;

- (BOOL)apm_isUrlString;

- (BOOL)apm_isLocalFileString;

- (BOOL)apm_isM3u8URlString;

/**
 是否是afts加密资源，先会判断是否是afts资源，如果不是则会返回NO，再判断是否是加密资源

 @return 是否是afts加密资源，先会判断是否是afts资源，如果不是则会返回NO，再判断是否是加密资源
 */
- (BOOL)apm_isEncryptedAftsResource;

/**
 是否是afts资源

 @return 是否是afts资源
 */
- (BOOL)apm_isAftsResource;

/**
 是否是afts 私有资源。先会判断是否是afts资源，如果不是则会返回NO，再判断是否是私有资源

 @return 是否是afts 私有资源
 */
- (BOOL)apm_isPrivateAftsResource;

/**
 返回base64+url安全编码的字符串

 @return 返回base64+url安全编码的字符串
 */
- (NSString *)apm_safeUrlBase64EncodeString;

@end
