//
//  APResourceLoaderHelper.h
//  APMultimedia
//
//  Created by Kris Tian on 2018/9/3.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface APResourceLoaderHelper : NSObject

/**
 根据本地文件路径判断content type

 @param fileURL 文件路径
 @return 文件对应的content type;
 */
+ (NSString *)contentTypeWithFile:(NSString *)fileURL;

/**
 根据data推测文件的content type

 @param data NSData
 @return data对应的content type
 */
+ (NSString *)contentTypeWithData:(NSData *)data;

/**
 根据文件后缀推测文件的content type

 @param extention 文件后缀
 @return 文件后缀对应的content type
 */
+ (NSString *)contentTypeWithPathExtension:(NSString *)extention;

@end
