//
//  APMAvif.h
//  APMAvif
//
//  Created by lwj on 2022/9/18.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <AntAvif/AntAvif.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, APMAvifResultCode) {
    APMAvifResultCodeSucceed        = 0,
    APMAvifResultCodeEncodeError    = -100, //编码错误
    APMAvifResultCodeDecodeError    = -101, //解码错误
    APMAvifResultCodeParamError     = -102, //参数错误
    APMAvifResultCodeDepthError     = -103, //位深错误,不支持的位深
    APMAvifResultCodeYuvConverError = -104, //yuv颜色转换错误
    APMAvifResultCodeUnknowError    = -999, //未知错误
};


@interface APMAvifResult : NSObject

@property (nonatomic, strong) UIImage *avifImage;            
@property (nonatomic, strong) NSData *pixels;                //图片像素数据
@property (nonatomic, assign) APMAvifResultCode resultCode;  //结果码
@property (nonatomic, assign) double yuvConverTime;          //yuv颜色转换用时,单位秒
@property (nonatomic, assign) double decodeTime;             // 整个解码用时,单位秒

+ (APMAvifResult *)rstWithCode:(APMAvifResultCode)code;

@end


@interface APMAvif : NSObject

/// 根据二进制文件内容判断是否是AVIF的图片
/// @param imageData 图片数据, uint8_t *
+ (BOOL)isAVIFImageData:(NSData*)imageData;


/// 快捷方法, 解码二进制AVIF文件为UIImage,默认scale为1
/// @param data 图片数据
/// @param forceDepth 强制位深,大于8的都转成8.如果false, 大于8位,返回错误码APMAvifResultCodeDepthError
+ (UIImage *)imageWithAVIFData:(NSData*)data forceDepth:(BOOL)forceDepth;

/// 快捷方法, 解码二进制AVIF文件为UIImage
/// @param data 图片数据
/// @param forceDepth 强制位深,大于8的都转成8.如果false, 大于8位,返回错误码APMAvifResultCodeDepthError
/// @param scale 缩放因子,如 400*400的图片,当scale为2时,输出图片为200*200
+ (UIImage *)imageWithAVIFData:(NSData*)data forceDepth:(BOOL)forceDepth scale:(CGFloat)scale;


/// 解码二进制AVIF数据,默认scale为1
/// @param data data 图片数据
/// @param forceDepth 强制位深,大于8的都转成8.如果false, 大于8位,返回错误码APMAvifResultCodeDepthError
+ (APMAvifResult *)avifResultWithAVIFData:(NSData*)data forceDepth:(BOOL)forceDepth;

/// 解码二进制AVIF数据
/// @param data 图片数据
/// @param forceDepth 强制位深,大于8的都转成8.如果false, 大于8位,返回错误码APMAvifResultCodeDepthError
/// @param scale 缩放因子,如 400*400的图片,当scale为2时,输出图片为200*200
+ (APMAvifResult *)avifResultWithAVIFData:(NSData*)data forceDepth:(BOOL)forceDepth scale:(CGFloat)scale;


@end

NS_ASSUME_NONNULL_END
