//
//  AMMAudioRecord.h
//  MobileFoundation
//
//  Created by Monster on 10/2/13.
//  Copyright (c) 2013 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "APMAudioRecordCallback.h"
#import "APAudioRecordSetting.h"
@protocol AMMAudioRecordDelegate;

@interface AMMAudioRecord : NSObject

@property (nonatomic, strong, readonly) APAudioRecordSetting *recordSetting;

/**
 *单例对象
 *
 *@return AMMAudioRecord单例对象
 */
+ (instancetype)sharedInstance;

/**
 *  开始语音录制
 *
 *  @param recordSetting   录制参数设置
 *  @param business              业务标识
 *  @param delegate              录制数据回调delegate
 *  @param callback              录制状态回调callback
 */
- (void)startRecordWithRecordSetting:(APAudioRecordSetting *)audioSetting
                            business:(NSString *)business
                            delegate:(id<AMMAudioRecordDelegate>)delegate
                            callback:(APMAudioRecordCallback *)callback;


/**
 *  取消录制
 */
- (void)cancelRecord;

/**
 *  暂停录制
 */
- (void)pauseRecord;

/**
 *  恢复录制
 */
- (void)resumeRecord;

/**
 *  完成录音
 */
- (void)stopRecord;

/**
 * 是否在录制中
 */
- (BOOL)isRecording;
/**
 *  录音权限
 */
+ (void)requestMicrophonePermission:(void (^)(BOOL granted))block;
@end

@protocol AMMAudioRecordDelegate <NSObject>
@optional
/**
 *  录制结束的回调
 *  录制结束的情况：
 *  1.  调用finishRecord完成录制
 *  2.  调用cancelRecord取消录制
 *  3.  录制时间超过设定的最大时间
 *  4.  录制保存的文件路径无效
 *  5.  录制失败
 */

- (void)recordFinishWithPCMData:(NSData *)pcmData encodeData:(NSData *)encodeData duration:(NSTimeInterval)duration format:(AudioStreamBasicDescription)format isKeepData:(BOOL)isKeepData finishState:(APMMAudioStopRecordStatus)state;

/**
 *  Audio队列音频编码
 *
 *  @param data
 */
- (void)recordAudioConvertData:(NSData*)data averageCostTime:(NSTimeInterval)costTime error:(NSError *)error time:(NSDate*)time;

/**
 * Audio队列PCM数据回调
 * @param pcmData
 * @param error  PCM数据获取错误信息
 * @param time PCM数据获取时间
 **/
- (void)recordAudioPCMData:(NSData *)pcmData error:(NSError *)error time:(NSDate *)time;

/**
 * Audio队列CMSampleBuffer数据回调
 * @param buffer CMSampleBuffer数据
 *
 * 备注:此buffer在回调后会立即释放，如果业务方切线程需要自己持有
 */
- (void)recordAudioSampleBuffer:(CMSampleBufferRef)buffer;
/**
 录音内部被打断
 */
- (void)recordAudioDidInterupted;

@end
