//
//  APSyncDataManager.h
//  APLongLinkService
//
//  Created by cuinacai on 15/4/21.
//  Copyright (c) 2015年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <APBaseInterfaceAdapter/APBaseInterfaceAdapter.h>

@protocol APSyncDataManagerDelegate <NSObject>

- (void)didReceiveSyncData:(NSData*)body header:(NSDictionary*)head;
@optional
- (void)didReceiveError:(NSError *)error;
@end

@interface APSyncDataManager : NSObject<MADataInterface,MAErrorInterface>
+(instancetype)syncDataManager:(id<APSyncDataManagerDelegate>)delegate;
/**
 *  sync流量监控，用hook方式实现
 *  @param upSize    上行流量
 *  @param downSize  下行流量
 */
-(void)flowStatisticUpFlow:(long long)upSize downFow:(long long)downSize;
/**
 *  sync流量监控，业务条数，用hook方式实现
 *  @param biz    业务名字
 *  @param count  收到业务数据条数
 */
+(void)receiveBizName:(NSString*)biz bizCount:(NSUInteger)count;
-(void)sendSyncData:(NSData*)syncData;
-(void)sendSyncHeader:(NSDictionary*)header;
-(void)sendSyncData:(NSData*)syncData forwardIP:(UInt32)fip header:(NSDictionary*)head;
//读扩散用，需要指定后端系统，mmtp_sys_id
-(void)sendSyncData:(NSData*)syncData forwardIP:(UInt32)fip header:(NSDictionary*)head params:(NSDictionary*)params;
-(void)sendThroughHttpHead:(NSDictionary*)head body:(NSData*)body forwardIP:(UInt32)fip;
-(void)sendSyncDataToSpanner:(NSData*)data;
-(void)sendStWith3001DataExt:(NSDictionary*)extInfo userId:(NSString*)uid seesionId:(NSString*)sid;
@end


@protocol APSyncDirectDataManagerDelegate <NSObject>
- (void)didReceiveSyncDirectData:(NSData*)body;
@end

@interface APSyncDirectDataManager : NSObject<MADataInterface>
+(instancetype)syncDirectDataManager:(id<APSyncDirectDataManagerDelegate>)delegate;
//-(void)sendSyncDirectData:(NSData*)syncData;
@end


