//
//  MAInitInfoInterface.h
//  Interface
//
//  Created by cuinacai on 15/3/27.
//  Copyright (c) 2015年 cuinacai. All rights reserved.
//
#import <Foundation/Foundation.h>
#import <CoreTelephony/CTTelephonyNetworkInfo.h>

//typedef enum
//{
//    NNotReachable     = 0,
//    NReachableViaWWAN2G = 1,
//    NReachableViaWWAN3G = 2,
//    NReachableViaWWAN4G = 3,
//    NReachableViaWiFi = 4,
//    NReachableViaUnknown = 5,
//    NReachableViaWWAN5G = 6,
//} NNetworkStatus;



typedef NS_ENUM(NSInteger, NetAccessType)
{
    NetAccessNone,          //无网络
    NetAccess2G,            //2g
    NetAccess3G,            //3g
    NetAccess4G,            //4g
    NetAccessWifi,          //wifi
    NetAccessUnknown,       //unknown
    NetAccess5G,            //5g
};

@protocol MAInitInfo <NSObject>

@property(nonatomic)NSInteger channel;

@optional
@property(nonatomic,strong)NSDictionary *info;
@property(nonatomic,strong)NSData* bytes;

@end

@protocol NetAccessInfo <NSObject>
/**
 *  iOS7以下      WIFI|WWAN|NotReachable
 *  iOS7及以上    WIFI|GPRS|WCDMA|HSDPA|HSUPA|CDMA1X|CDMAEVDOREV0|CDMAEVDOREVA|CDMAEVDOREVB|HRPD|LTE|UNKNOWN|NotReachable
 *
 *  @return 网络类型名称
 */
@property (nonatomic,strong,readonly) NSString* appleNetAccessInfo;
@property (nonatomic,readonly) NetAccessType accessType;
//@property (nonatomic,strong,readonly) NSString* appleMobileNetworkInfo;

-(CTTelephonyNetworkInfo*)getCTTelephonyNetworkInfo;

@optional
/**
 *  给域名取ip列表
 *
 *  @param host
 *
 *  @return <#return value description#>
 */
- (NSArray<NSString*>*)getIpListByHost:(NSString*)host;

/**
 *  给域名取ip_port列表
 *
 *  @param host
 *
 *  @return [ip:port]
 */
- (NSArray<NSString*>*)getIpPortListByHost:(NSString*)host;

/**
 *  给域名取ip_port列表，按需同步获取
 *
 *  @param host
 *
 *  @return [ip:port]
 */
- (NSArray<NSString*>*)getIpPortListOnDemandByHostSync:(NSString *)host;

/**
 *  删除host域名下面的ip缓存
 *
 *  @param host不包含port
 *
 *  @return result
 */
- (BOOL)cleanDnsCacheForHost:(NSString*)host;

@end

@protocol MAInitInfoInterface <NSObject>
@required
/**
 *	@brief	获取init所需的NSDictionary
 *
 *	@return NSDictionary
 */
- (id<MAInitInfo>)getInitInfo;
@optional
/**
 *	@brief	userid
 *
 *	@return NSString
 */
-(NSString*)getUserId;
@end
