//
//  MADataInterface.h
//  Interface
//
//  Created by cuinacai on 15/3/27.
//  Copyright (c) 2015年 cuinacai. All rights reserved.
//

#import <Foundation/Foundation.h>
@protocol MAAccessInterface;

@protocol MADataInterface <NSObject>
@optional
/**
 *	@brief	收到数据回调接口
 *
 *	@param 	access     MAAccess
 *  @param 	data       NSData
 *
 *	@return
 */
- (void)access:(id<MAAccessInterface>)access didReceiveDataWithHead:(NSDictionary*)head andBody:(NSData*)body;

/**
 *	@brief	发送数据发送超时回调
 *
 *	@param 	access     MAAccess
 *  @param 	head       消息的头，body不用再传了
 *
 *	@return
 */
-(void)dataSendtimeout:(id<MAAccessInterface>)access withMsgHead:(NSDictionary*)head;

/**
 *  rpc发送时候，这条消息的tcp层面信息
 *
 *  @param dataId   rpc的ip
 *  @param headlen  rpc数据部分的头长度，就是hpack压缩后的长度
 *  @param lenaftZip    rpc数据部分在压缩后的长度
 *  @param pkglen   mmtp包的总长度
 */
-(void)rpcSendToTcpInfo:(NSInteger)dataId dataHeadLen:(NSInteger)headlen lenafterZip:(NSInteger)lenaftZip totalLenPkg:(NSInteger)pkglen;

/**
 *  rpc发送进度消息
 *
 *  @param dataId   rpc的id
 *  @param progress  rpc进度, 0-100
 */
-(void)updateRpc:(NSInteger)dataId progress:(NSInteger)progress;

@end
