//
//  MADataInterface.h
//  Interface
//
//  Created by cuinacai on 15/3/27.
//  Copyright (c) 2015年 cuinacai. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MADataInterface.h"
#import "MAErrorInterface.h"
#import "MAStatusInterface.h"
#import "MAInitInfoInterface.h"

typedef NS_ENUM(NSInteger, MAChannel)
{
    MAChannelRPC    = 1,//RPC
    MAChannelSYNC,   //SYNC
    MAChannelSYNCDIRECT,   //SYNC_DIRECT
};

typedef NS_ENUM(NSInteger, MAAccessStatus)
{
    MAAccessStatusNotAvailable = 0,//当前网络不可用
    MAAccessStatusConnecting,      //连接中
    MAAccessStatusConnected,       //连接上
    MAAccessStatusConnectFailed    //连接失败
};

@protocol MAAccessInterface <NSObject>
@optional
@property (nonatomic) BOOL shortLinkChannelOpen;                //短连接是否开
@property (nonatomic) BOOL netCardIpV6Only;
/**
 * 获得单例
 */
+(instancetype)shareInstance;

/**
 *	@brief	注册数据回调
 *
 *	@param 	obj 	    head
 *	@param 	channel     目前有RPC或者SYNC
 *
 *	@return
 */
-(void)registerDataObserver:(id<MADataInterface>)obj channel:(MAChannel)channel;


/**
 *	@brief	错误监听
 *
 *	@param 	errorObserver     MAErrorInterface实现
 *
 *	@return
 */
-(void)addErrorObserver:(id<MAErrorInterface>)errorObserver;
/**
 *	@brief	info提供者
 *
 *	@param 	infoObject     MAInitInfoInterface实现
 *
 *	@return
 */
-(void)addInfoProvider:(id<MAInitInfoInterface>)infoProvider;
/**
 *	@brief	状态变化监听
 *
 *	@param 	statusObserver     MAStatusInterface实现
 *
 *	@return
 */
-(void)addStatusObserver:(id<MAStatusInterface>)statusObserver;
/**
 *	@brief	查询MAccess的状态
 *
 *	@return MAAccessStatus
 */
-(MAAccessStatus)accessStatus;

/**
 *  发送消息，带消息id
 *
 *  @param head    消息头key-value对
 *  @param body    消息体
 *  @param channel 消息业务类型
 *  @param dataId  数据id
 *  @param passSP  是否需要spanner转发
 */
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId;
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt;
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt forwardIP:(UInt32)fip;
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt canHttp:(BOOL)canHttp;
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt forwardIP:(UInt32)fip canHttp:(BOOL)canHttp;
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt canHttp:(BOOL)canHttp canZstd:(BOOL)canZstd;
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt forwardIP:(UInt32)fip canHttp:(BOOL)canHttp canZstd:(BOOL)canZstd;
//增加扩展map，携带了networkctrl或者apmobilenetwork的东西
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt forwardIP:(UInt32)fip canHttp:(BOOL)canHttp canZstd:(BOOL)canZstd extraParams:(NSDictionary*)extraParams;
/**
 *  sync 读扩散使用
 *
 *  @param head    消息头key-value对
 *  @param body    消息体
 *  @param channel 消息业务类型
 *  @param dataId  数据id
 *  @param passSP  是否需要spanner转发
 *  @param nrt     是否可重试
 *  @param fip     forwardIP
 *  @param params  扩展参数
 */
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt forwardIP:(UInt32)fip params:(NSDictionary*)params;

-(void)sendData:(NSData*)data channel:(MAChannel)channel passSpanner:(BOOL)passSP;
/**
 *  仅通过短连接发送数据
 *
 *  @param head   头k-v对
 *  @param body   体
 *  @param ch     通道号
 *  @param dataId 数据编号
 *  @param passSp 是否要spanner转发
 *  @param fip    是否让spanner转到固定后端ip
 */
-(void)sendThroughHttpHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)ch dataId:(NSUInteger)dataId passSpanner:(BOOL)passSp forwardIP:(UInt32)fip;

/**
 *  携带扩展参数登陆的信息通知
 *
 *  @param isIn 登入或登出
 *  @param uid  用户ID，登出不填
 *  @param sid  sid，登出不填
 *  @param extInfo  扩展参数，登出不填
 */
-(void)userLogInOut:(BOOL)isIn userId:(NSString*)uid cachedSessionId:(NSString*)sid extInfo:(NSDictionary*)extInfo;
@end
