//
//  DTSyncInterface.h
//  APLongLinkService
//
//  Created by cuinacai on 2017/4/20.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AntNetworkAdapter/AntNetworkAdapter.h>

@interface DTSyncInterface : NSObject

// 是否开启SSL
@property (nonatomic, assign) BOOL sslEnabled;

+ (instancetype)sharedInstance;
/**
 *  Sync使用的应用Id，默认实现为
 *  [[[NSBundle mainBundle] infoDictionary] objectForKey:@"Product ID"]
 *
 *  @return 应用Id
 */
- (NSString*)productId;
/**
 *  Sync使用的应用版本号，默认实现为
 *  [[[NSBundle mainBundle] infoDictionary] objectForKey:@"Product Version"];;
 *
 *  @return 应用版本号
 */
- (NSString*)productVersion;
/**
 *  Sync使用的应用名字appname，默认实现返回@"ALIPAY_WALLET"
 *
 *  @return 应用名字
 */
- (NSString*)currentAppName;

/**
 *  Sync支持多地区切换，不支持直接返回YES，默认返回YES
 *
 *  @return 当前是不是主app
 */
- (BOOL)isMainAppName;

/**
 *  Sync支持多地区切换，主APP的名字,默认实现返回@"ALIPAY_WALLET"
 *
 *  @return 主APP名字
 */
- (NSString*)mainAppName;

/**
 App当前处于后台
 注意：！！如果main之前获取，认为是前台
 @return YES 后台 ; NO前台或回前台过程中
 */
- (BOOL)isBackground;
/**
App当前处于后台
注意：！！如果main之前获取，认为是前台
@return YES 后台 ; NO前台或回前台过程中
*/
-(NSString*)groupName;

#ifdef USE_MPASS_SDK
/**
 *  Sync使用的应用appId，默认实现为返回nil
 *
 *  @return appId
 */
- (NSString*)appId;
/**
 *  Sync使用的应用platform，默认实现为返回nil
 *
 *  @return platform
 */
- (NSString*)platform;
/**
 *  Sync使用的应用长连接端口，默认实现为返回0
 *
 *  @return syncport
 */
- (NSInteger)syncPort;
/**
 *  Sync使用的应用长连接host，默认实现为返回nil
 *
 *  @return syncserver
 */
- (NSString*)syncServer;
/**
 *  Sync使用的应用workspaceId，默认实现为返回nil
 *
 *  @return workspaceId
 */
- (NSString*)workspaceId;

// 是否启用MDC
- (BOOL)mdcEnabled;

// 是否使用MDC下发的IPv6
- (BOOL)mdcIpv6Enabled;

// 是否使用MDC下发的Port
- (BOOL)mdcPortEnabled;
#endif
@end
