//
//  url_request.h
//  dtn
//
//  Created by murong on 2021/7/22.
//  Copyright © 2021 murong. All rights reserved.
//

#ifndef BIFROST_URL_REQUEST_H
#define BIFROST_URL_REQUEST_H

#include <cstdint>
#include <string>
#include <vector>
#include <map>

#include "url_response.h"
#include "dtn_comm.h"

namespace ant_bifrost { namespace dtn {
class URLRequest;
class DtnCallback {
public:
    virtual ~DtnCallback() = default;
    virtual void OnStart(const URLRequest& _request) = 0;
    virtual int32_t ObtainRequestBody(const URLRequest& _request, void* _buf, size_t _offset, size_t _max_length) = 0;
    virtual void OnResponseHeaders(const URLRequest& _request,
                                   const std::string& _http_version, uint16_t _status_code, const std::string& _reason_phrase,
                                   const ant_bifrost::dtn::HeaderFields& _response_headers, const std::map<std::string, std::string> &_metrics) = 0;
    virtual bool OnReceivedRedirect(const URLRequest& _request, const RedirectInfo& redirect_info) = 0;
    virtual size_t OnResponseBody(const URLRequest& _request, const void* _buf, size_t _length) = 0;
    virtual void OnComplete(const URLRequest& _request, const dtn::DtnTaskResult& _result) = 0;
    virtual bool OnRetry(const URLRequest& _request, int _type) = 0;
};

struct URLRequest {
    explicit URLRequest(int32_t _request_id);
    URLRequest();

    int32_t                               request_id;
    std::string                           url;
    ant_bifrost::dtn::RequestMethod              request_method;
    uint32_t                              request_timeout;
    uint32_t                              socket_timeout;//首包、包包超时，默认0使用自动模式
    uint32_t                              wait_timeout;//队列等待时间(即：排队等待时间)
    uint64_t                              create_task_time;
    bool                                  follow_redirect;
    int32_t                               max_redirect_count;
    int32_t                               channel_select;
    bool                                  need_check_cert;
    bool                                  downgrade_to_https_when_needed;
    bool                                  is_gquic;
    DtnCallback*                          cb;
    dtn::HeaderFields  ext_headers;    //外部设置的请求头
    std::map<std::string, std::string>    annotation;     //注解
    ant_bifrost::dtn::DtnRequestType             request_type;//请求类型
};
}}
#endif //BIFROST_URL_REQUEST_H
