//
//  mnet_bifrost.hpp
//  AMNet
//
//  Created by feisong on 2017/3/30.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#ifndef mnet_bifrost_hpp
#define mnet_bifrost_hpp

#include <stdio.h>
#include <pthread.h>
#include "MnetThreadPosixAccess.h"
extern "C" {
#include "bifrost.h"
}

using namespace std;

extern const char *sType;
/**
 * register
 */
struct registering : BIFROST_result_t{
    
    BIFROST_registering_t register_t;
    
    registering();
    
    static void notify_registering(void *arg,bool result){
        if(result){
            diagnoseLog(sType, "registering ok");
        }else{
            diagnoseLog(sType, "registering fail");
        }
        registering *inf = static_cast<registering*>(arg);
        delete inf;
    }
};




/**
 * launch
 */
struct activating : BIFROST_result_t{
public:
    ::BIFROST_activating_t _activating_t;
    ::BIFROST_storage_t    _storage_t;
    ::BIFROST_linkage_t    _linkage_t;
    ::BIFROST_mqtt_callback_t _mqtt_callback_t;
    ::BIFROST_service_t    _service_t[3];
    ::BIFROST_channel_t    _channel_t[3];
    ::BIFROST_kv_t         _cfg_long_kv[10];
    ::BIFROST_kv_t         _cfg_shrt_kv[10];
    ::BIFROST_kv_t         _cfg_h2_kv[10];
    ::BIFROST_kv_t         _cfg_quic_kv[10];
    ::BIFROST_kv_t         _cfg_params_kv[10];

    activating();
    
    ~activating();
    
private:
    
    static void notify_activating(void *arg,bool result){
        if(result){
            localDebug(NULL, "activating ok");
            diagnoseLog(sType, "activating ok");
        }else{
             localDebug(NULL, "activating fail");
            diagnoseLog(sType, "activating fail");
        }
        activating *inf = static_cast<activating *>(arg);
        delete inf;
        
        //注册atexit回调, 在激活之后注册，确保
        registerAtExitCallback();
    }
};

/**
 * post
 */
struct posting : BIFROST_result_t{
    BIFROST_posting_t _post;
    
    posting();
    
    ~posting();
    
    static void notify_posting(void *arg,bool result);
};

struct altering : BIFROST_result_t{
    BIFROST_altering_t _alter;
    
    altering();
    
    ~altering();
    
    static void notify_alter(void *arg,bool result){
        altering *inf = static_cast<altering *>(arg);
        stringstream ss;
        if(result){
            ss<<"alter ok,";
        }else{
            ss<<"alter fail,";
        }
        ss<<"status:"<<inf->_alter.status;
        if(inf->_alter.inf.major){
            ss<<",major:"<<inf->_alter.inf.major;
        }
        if(inf->_alter.inf.minor){
            ss<<",minor:"<<inf->_alter.inf.minor;
        }
        localDebug(NULL, ss.str().c_str());
        diagnoseLog(sType, ss.str().c_str());
        delete inf;
    }
};

class b_storage : public BIFROST_result_t {
public:
    ::BIFROST_storage_t    _storage_t;

    ~b_storage() {}
    static void notify_storage(void *arg, bool result) {}
  
    static b_storage* instance();

private:
    b_storage();
};

struct alerting : BIFROST_result_t{
    BIFROST_alerting_t _alert;
    
    alerting();
    
    static void notify_alert(void *arg,bool result){
        alerting *inf = static_cast<alerting *>(arg);
        stringstream ss;
        if(result){
            ss<<"alert ok,";
        }else{
            ss<<"alert fail,";
        }
        ss<<"receipt:"<<inf->_alert.receipt<<",duration:"<<inf->_alert.duration;
        localDebug(NULL, ss.str().c_str());
        diagnoseLog(sType, ss.str().c_str());
        delete inf;
    }
};

struct switching : BIFROST_result_t{
    BIFROST_switching_t _swch;
    
    switching();
    
    ~switching();
    
    static void notify_switch(void *arg,bool result){
        switching *inf = static_cast<switching *>(arg);
        stringstream ss;
        if(result){
            ss<<"switching ok,";
        }else{
            ss<<"switching fail,";
        }
        for(size_t i = 0;i<inf->_swch.count_swch;i++){
            ss<<inf->_swch.swch[i].key<<":"<<inf->_swch.swch[i].val<<";";
        }
        localDebug(NULL, ss.str().c_str());
        diagnoseLog(sType, ss.str().c_str());
        delete inf;
    }
};

struct inactivating : BIFROST_result_t{
    long long id;
    inactivating();
    static void notify_inactivating(void *arg,bool result);
};

//用于流式RPC响应的函数
typedef void (*streamingObtainFun)(const BIFROST_obtaining_t *inf);
typedef bool (*streamingErrorFun)(long long receipt, int err, const char *inf);

class MnetBifrost{

public:
    static MnetBifrost& Instance(){
//        if (singleton == NULL) {
//            pthread_mutex_lock(&singletonMutex);
//            if (singleton == NULL) {
//                singleton = new MnetBifrost;
//            }
//            pthread_mutex_unlock(&singletonMutex);
//        }
//        return *singleton;
        return _instance;
    }

    /** 初始化 */
    void init();
    
    //启动统一库  返回true表示成功 返回false表示失败 走老库
    bool activate(BIFROST_activating_t &activating);
    
    /**析构统一库*/
    void uninit();
    
    void initStreaming(streamingObtainFun obtain, streamingErrorFun error);
    
public:
    //从普通介质中获取。
    //返回取到的值，若不为NULL，则将字节数填入(*len)中。
    //返回值必须可以使用free函数来释放。
    static void *getCommon(void *arg, const char *key, size_t *len);
    /*------------------------------------------------------------------------*/
    //从安全介质（比如黑匣子）中获取。
    //返回取到的值，若不为NULL，则将字节数填入(*len)中。
    //返回值必须可以使用free函数来释放。
    static void *getSecure(void *arg, const char *key, size_t *len);
    /*------------------------------------------------------------------------*/
    //以同步方式保存到普通介质中。
    //len是val指向的值的字节数。
    static void putCommon(void *arg, const char *key,const void *val, size_t len);
    /*------------------------------------------------------------------------*/
    //以同步方式保存到安全介质（比如黑匣子）中。
    //len是val指向的值的字节数。
    static void putSecure(void *arg, const char *key,const void *val, size_t len);
    /*------------------------------------------------------------------------*/
    //以异步方式保存到普通介质中。
    //len是val指向的值的字节数。
    static void putCommonAsync(void       *arg,
                             const char *key,
                             const void *val,
                             size_t      len);
    /*------------------------------------------------------------------------*/
    //以异步方式保存到安全介质（比如黑匣子）中。
    //len是val指向的值的字节数。
    static void putSecureAsync(void       *arg,
                             const char *key,
                             const void *val,
                             size_t      len);
    /*------------------------------------------------------------------------*/
    //暂存准备保存到普通介质中的数据。
    //len是val指向的值的字节数。
    static void cacheCommon(void       *arg,
                         const char *key,
                         const void *val,
                         size_t      len);
    /*------------------------------------------------------------------------*/
    //暂存准备保存到安全介质（比如黑匣子）中的数据。
    //len是val指向的值的字节数。
    static void cacheSecure(void       *arg,
                         const char *key,
                         const void *val,
                         size_t      len);
    /*------------------------------------------------------------------------*/
    //将暂存的数据以异步方式保存到对应介质中。
    static void onCommit(void *arg);
    /*------------------------------------------------------------------------*/
    //从普通介质中删除。
    static void delCommon(void *arg, const char *key);
    /*------------------------------------------------------------------------*/
    //获取文件数据。
    static void *getBigData(void *arg, const char *key, size_t *len, bool common);
    /*------------------------------------------------------------------------*/
    //存储大数据，一般是要单独存放文件，key为文件名
    static void putBigDataAsync(void       *arg,
                                const char *key,
                                const void *val,
                                size_t      len,
                                bool        common);
    /*------------------------------------------------------------------------*/
    //删除大数据文件。
    static void delBigData(void *arg, const char *key);
    /*------------------------------------------------------------------------*/
    /**是否已经Inactivate*/
    static bool isUninit();
    
/*=====================================================================================*/
    //连接状态变化时的回调。
    //state为新的状态，取值在BIFROST_state_t定义范围内。
    static void onChange(void *arg, int state);
    /*------------------------------------------------------------------------*/
    //连接完成时的回调。
    static void onTouch(void *arg, const BIFROST_touching_t *rpt);
    /*------------------------------------------------------------------------*/
    //心跳一定次数后的回调。
    static void onKeep(void                     *arg,
                 const BIFROST_touching_t *rpt_touch,
                 const BIFROST_keeping_t  *rpt_hb,
                 size_t                    cnt_hb);
    /*------------------------------------------------------------------------*/
    //连接断开时的回调。
    static void onSeparate(void                       *arg,
                     const BIFROST_touching_t   *rpt_touch,
                     const BIFROST_separating_t *rpt_separate);
    /*------------------------------------------------------------------------*/
    //准备向服务器发送初始化请求时的回调。
    //收集各channel的init数据。
    //未经序列化的填入(*value_0)和(*count_0)中。
    //序列化过的填入(*value_1)和(*count_1)中。
    //输出的(*value_0)和(*value_1)不该为NULL，
    //且指向的元素中的各级指针必须都可以使用free函数来释放。
    static void onGain(void                  *arg,
                 BIFROST_collecting_t **value_0,
                 size_t                *count_0,
                 BIFROST_gathering_t  **value_1,
                 size_t                *count_1);
    /*------------------------------------------------------------------------*/
    //收到初始化响应时的回调。
    static void onEstablish(void *arg);
    /*------------------------------------------------------------------------*/
    //要求重新登录时的回调。
    static void onReactivate(void *arg);
    /*------------------------------------------------------------------------*/
    //被流控时的回调。
    //delay为多少秒后将重连。
    //inf为用JSON编码的附加信息。
    static void onServerRestrict(void *arg, int delay, const char *inf);
    /*------------------------------------------------------------------------*/
    //额外配置上报。
    static void onCommand(void *arg, const BIFROST_bin_t *bin);
    /*------------------------------------------------------------------------*/
    //上层提交的数据超时未被确认时的回调。
    //receipt是被发数据的唯一标识（对于RPC就是RPD-ID）。
    //err为错误类型，在BIFROST_err_t定义范围内；-1表示无错误。
    //inf为描述。
    static void onSorry(void *arg, long long receipt, int err, const char *inf,int target_type, const BIFROST_cfg_t *data);
    /*------------------------------------------------------------------------*/
    //上层提交的数据发送进度通知
    static void onProgressUpdate(void *arg, long long receipt, int progress);
    /*------------------------------------------------------------------------*/
    //init响应传给上层。
    static void onInitRsp(void *arg, const BIFROST_init_rsp_t *inf);
    
    static bool onIsConnectionlimited(void *arg,int32_t channel_select);
    /*------------------------------------------------------------------------*/
    //要求补偿sessionid时的回调.
    static void onResendSessionid(void *arg);
    /*------------------------------------------------------------------------*/
    //上报埋点信息
    static void onReportPerfInfo(void *arg, const BIFROST_cfg_t *data);
    //埋点flag
    //target_type: mmtp=0,http2=1,mqtt=2,quic=3
    static void libFlag(int target_type, std::map<std::string,std::string>& map);
    //nan to double
    static double nan2Double(double d);
/*====================================================================================*/    
    //收到RPC数据时的回调。
    static void onObtainRPC(void *arg, const BIFROST_obtaining_t *inf);
    /*------------------------------------------------------------------------*/
    //数据发出后的回调。
    //receipt是被发数据的唯一标识（对于RPC就是RPD-ID）。
    //len_raw是压缩前的大小。
    //len_pkg是压缩后的大小。
    static void onTellRPC(void *arg, long long receipt, size_t len_raw, size_t len_pkg);
    //回收发不出去的RPC数据时的回调。
    static void onRecycleRPC(void *arg, const BIFROST_pkg_t *pkg);
    //收到SYNC时的回调。
    static void onObtainSYNC(void *arg, const BIFROST_obtaining_t *inf);
    /*------------------------------------------------------------------------*/
    //数据发出后的回调。
    //receipt是被发数据的唯一标识（对于RPC就是RPD-ID）。
    //len_raw是压缩前的大小。
    //len_pkg是压缩后的大小。
    static void onTellSYNC(void *arg, long long receipt, size_t len_raw, size_t len_pkg);
    //回收发不出去的SYNC时的回调。
    static void onRecycleSYNC(void *arg, const BIFROST_pkg_t *pkg);

/*====================================================================================*/
    //记录日志的函数。
    static void onRecord(void       *arg,
                   const char *level,
                   const char *tag,
                   const char *content);
    /*------------------------------------------------------------------------*/
    static bool onAppProxyInfo(void         *arg,
                               const char   *host,
                               char        **host_proxy,
                               int          *port_proxy,
                               char        **username,
                               char        **password,
                               int          *proxy_type);
    /*------------------------------------------------------------------------*/
    //获取应用的路径。
    //输出的(*path)不该为NULL，且指向的字符串以使用free函数来释放。
    static void onAppPath(void *arg, char **path);
    /*------------------------------------------------------------------------*/
    //输出的(*utdid)不该为NULL，且指向的字符串以使用free函数来释放。
    static void onAppUtdid(void *arg, char **utdid);
    /*------------------------------------------------------------------------*/
    //获取版本号信息。
    static unsigned int onAppVersion(void *arg);
    /*------------------------------------------------------------------------*/
    //获取账号信息。
    //输出的(*name)不该为NULL，且指向的字符串以使用free函数来释放。
    //返回是否登录。
    static bool onAccount(void *arg, char **name, long long *uin);
    /*------------------------------------------------------------------------*/
    //获取设备信息。
    //输出的(*name)和(*type)不该为NULL，且指向的字符串以使用free函数来释放。
    static void onDevice(void *arg, char **name, char **type);
    /*------------------------------------------------------------------------*/
    //get httpdns ip
    //return the httpdns ips, and the ips_size is the total count of result ips
    static char** onNewDns(void *arg, const char *host, int *ips_size);
    //on demand get httpdns ip sync
    //return the httpdns ips, and the ips_size is the total count of result ips
    static char** onDnsOnDemand(void *arg, const char *host, int *ips_size);
    //clean httpdns ip for host
    //return the result
    static bool cleanNewDns(void *arg, const char *host);
    /*------------------------------------------------------------------------*/
    //使用数据网卡的前置检查。
    static bool bindCellularCheck(void *arg, const char *host, int fd, const int index);
    /*------------------------------------------------------------------------*/
    //真正使用数据网卡后的回调。
    static void bindCellularNotify(void *arg, bool result);
/*====================================================================================*/
     static void onNotify(void *arg, bool result);
/*====================================================================================*/
//    //the return value(void *) must can be free outside
//    //the len praram set the length of void* data
//    static void* onMQTTConnectMsg(void *arg, size_t *len);
//    /*------------------------------------------------------------------------*/
//    //the return value(void *) must can be free outside
//    //the len praram set the length of void* data
//    static void* onMQTTHBReqMsg(void *arg, size_t *len);
//    /*------------------------------------------------------------------------*/
//    //return value: >0 is the decode length, 0 is to continue to read, -1 is error
//    //ack_msgid is the msgid of the server response the client request
//    //type is the decode frame type
//    //notice: one time decode one frame
//    static int onMQTTDecode(void             *arg,
//                       const ::uint8_t  *data,
//                       size_t            size,
//                       int              *ack_msgid,
//                       int              *type);
//    /*------------------------------------------------------------------------*/
//    static void onMQTTDataResult(void          *arg,
//                             long long      pkg_id,
//                             int            err_code,
//                             const char    *err_msg);
/*====================================================================================*/
    //国密回调函数，底层查看该host是否支持国密
    //域名host是否支持国密双证书，lib_type为1表示STN，为2表示DTN
    static bool isHostSupportUseGm(void *arg, const char *host, const int lib_type);
/*====================================================================================*/
private:
    //rpc流量统计
    static std::map<uint64_t,uint64_t>& getRpcTrafficMap();
   
    /**构建统一错误码字符串*/
    static void buildUErrorCode(std::string& _u_err_code_str, const char* _cmd_err_type, const int _error_code);
    static void buildUErrorCode(std::string& _u_err_code_str, const int _cmd_err_type, const int _error_code);
    static void buildUErrorCode(std::string& _u_err_code_str, const std::string& _cmd_err_type, const std::string& _error_code);
    static void insertPreUErrCode(std::map<std::string, std::string>& _from_map, std::map<std::string, std::string>& _to_map);
        
private:
    MnetBifrost();
//    static MnetBifrost *singleton;
    static MnetBifrost _instance;
    static pthread_mutex_t     singletonMutex;
    /**是否未初始化*/
    static bool _uninit;
    
    static streamingObtainFun streamingObtain;
    static streamingErrorFun  streamingError;
    
};

/**
  record the rpc and for anr check
 */
void bifrostPostCheck(long long receipt);
/**
   rpc timeout, and check the mng thread is dead or not
 */
void bifrostAlertCheck(long long receipt, bool timeout);

#endif /* mnet_bifrost_hpp */
