//
//  dtn_switch.h
//  dtn-mac
//
//  Created by chenhan on 2020/6/6.
//  Copyright © 2020 zhuobin.hzb. All rights reserved.
//

#ifndef dtn_switch_h
#define dtn_switch_h
#include <string>
#include <map>
#include <vector>
#include "dtn_comm.h"

namespace ant_bifrost { namespace dtn {

class DtnSwitch {
public:
    static DtnSwitch* Instance();
    void SetSwitch(std::map<std::string, std::string>& _cfg);
private:
    DtnSwitch();
    virtual ~DtnSwitch() = default;
    void UpdateReqestWaitQueueCfg(std::string& _cfg);
    void UpdateDomainConvergeCfg(std::map<std::string, std::string>& _cfg);
    bool IsConvergeHostInUrl(const std::vector<std::string> &_converge_hosts,const std::string &_url);
    void UpdateHostKeepAliveCfg(const std::map<std::string, std::string>& _cfg);
    void Update0RTTCfg(const std::string& _0rtt_cfg);
    void UpdateRetyTimeCfg(const std::string& _time_cfg);
    void UpdateValueCfg(const std::map<std::string, std::string>& _cfg);

public:
    bool isEnableZeroRtt();
    bool isEnableTlsv1_3();
    bool isEnableTlsv1_3_0rtt(const char *_host);
    bool isEnableQuiclb();
    bool isEnableQuicGRO();
    bool isEnableRaiseThreadPriority();
    bool canPrintInfoLog();
    bool isEnableRange();
    bool isIgnoreUnknownSsid();
    bool needReportLinkPerfLog();
    bool isEnableSystemCertVerify();
    bool isNetchangeOptim();
    bool isEnableNetInfo();
    bool isEnableReqWaitQueue();
    bool isEnableNoBodyFix();
    bool isEnableMultipleHeadersFix();
    bool isDomainConverge();
    void FillDtnGroup(std::string& _ret_group);
    bool HostInAliDomainKeyWords(const std::string &_host);
    bool ForceGwHttps();
    bool CdnConverge();
    bool IsEnableRetNum2ND3RD();
    /**
     * 检查MDN收敛灰度配置
     */
    bool CheckMdnConvergeSwitch(const std::string &_url);
    void FillMdnTargetHost(std::string &_target_host);
    static uint64_t GetKeepAlivePeriod(int32_t _channel_select, const std::string& _host);
    static uint64_t GetDtnNotThirdReqRetryTimeMs();
    static uint64_t GetDtnThirdReqRetryTimeMs();
    static void SetPeerFinHost(const std::string& _host);
    static bool IsPeerFinHost(const std::string& _host);
    static bool IsEnableCheckThreadIdle();
    static bool IsEnableCheckCdnDownStatus();
    static bool IsEnableCheckFastCleanThread();
    static bool IsEnableSessionHostCtl();
    static uint32_t GetSessionMaxPerHost();
    static uint32_t GetSessionMaxAliveTime();
    static bool IsEnableRecordH2();
    static bool IsEnableFixExceedBody();
    static bool IsEnableThirdUseMaxFPkgTimeout();
    static bool IsEnableOnDemandDns();
    static bool IsEnableQuicSelFix();

public:
    const std::string key_dtn_0_rtt_;
    const std::string key_dtn_quiclb_;
    const std::string key_dtn_quicgro_;
    const std::string key_dtn_channel_select_;
    const std::string key_dtn_quic_switch_;
    const std::string key_dtn_sos_;
    const std::string key_dtn_raise_thread_priority_;
    const std::string key_dtn_print_info_log_;
    const std::string key_dtn_use_net_source_;
    const std::string key_dtn_more_main_ip_;
    const std::string key_dtn_clean_ipv6_;
    const std::string key_dtn_local_dns_filter_;
    const std::string key_dtn_enable_tlsv1_3_;
    const std::string key_dtn_tlsv1_3_0rtt_;
    const std::string key_dtn_disable_quic_record_;
    const std::string key_dtn_enable_range_;
    const std::string key_dtn_ignore_unknown_ssid_;
    const std::string key_dtn_rpt_ln_perf_log_;

    const std::string key_dtn_quic_only_;
    const std::string key_dtn_quic_support_;
    const std::string key_dtn_http2_support_;
    const std::string key_dtn_protocol_support_;
    const std::string key_dtn_system_cert_verify_;
    const std::string key_dtn_gm_tls_;
    const std::string key_dtn_save_ticket_;
    const std::string key_dtn_save_ticket_use_mng_;

    static const bool def_val_dtn_true;
    static const bool def_val_dtn_false;

    const std::string val_open_;
    const std::string val_close_;
    const std::string val_h1_;
    const std::string val_h12_;
    const std::string val_h123_;
    const std::string key_dtn_stay_connections_;
    const std::string key_dtn_netchange_optim_;
    const std::string key_dtn_enable_net_info_;
    const std::string key_dtn_enable_req_wait_queue_;
    const std::string key_dtn_enable_no_body_fix_;
    const std::string key_dtn_enable_multi_head_fix_;
    const std::string key_dtn_req_exc_max_count_;
    const std::string key_dtn_group_;
    const std::string key_c_interface_;
    const std::string key_disable_high_avai_opt_;
    const std::string key_dtn_domain_converge_;
    const std::string key_dtn_adkl_;
    const std::string key_dtn_gwforcehttps_;
    const std::string key_dtn_cdnconverge_;
    const std::string key_dtn_mdnconverge_switch_;
    const std::string key_dtn_mdnconverge_target_;
    const std::string key_dtn_mdnconverge_hosts_;
    const std::string key_dtn_render_alive_time_;
    const std::string key_dtn_session_alive_time_;
    const std::string key_dtn_hosts_0rtt_;
    const std::string key_dtn_req_retry_time_;
    const std::string key_dtn_ret_num_2nd_3rd_;
    const std::string key_dtn_check_thread_idle_;
    const std::string key_dtn_check_cdn_down_status_;
    const std::string key_dtn_fast_clean_thread_;
    const std::string key_dtn_sess_host_ctl_;
    const std::string key_dtn_sess_max_alive_time_;
    const std::string key_dtn_sess_max_cnt_per_host_;
    const std::string key_dtn_record_h2_;
    const std::string key_dtn_fix_exceed_bd_;
    const std::string key_dtn_third_use_max_fpkg_to_;//third post use first pkg pkgpkg timeout
    const std::string key_dtn_on_demand_dns_;
    const std::string key_dtn_quic_sel_fix_;
    
    std::string dtn_group_;
    std::vector<std::string> adkl_;//内部域名关键词
    std::string mdn_target_host_;
    bool mdnconverge_use_defalut_;
    std::vector<std::string> mdn_converge_hosts_;//需要mdn的host
    std::vector<std::string> hosts_0rtt_;//指定支持0rtt的host
    
    static DtnSwitch* instance_;
};

#define key_dtn_0_rtt                 DtnSwitch::Instance()->key_dtn_0_rtt_
#define key_dtn_quiclb                DtnSwitch::Instance()->key_dtn_quiclb_
#define key_dtn_quicgro               DtnSwitch::Instance()->key_dtn_quicgro_
#define key_dtn_channel_select        DtnSwitch::Instance()->key_dtn_channel_select_
#define key_dtn_quic_switch           DtnSwitch::Instance()->key_dtn_quic_switch_
#define key_dtn_sos                   DtnSwitch::Instance()->key_dtn_sos_
#define key_dtn_raise_thread_priority DtnSwitch::Instance()->key_dtn_raise_thread_priority_
#define key_dtn_print_info_log        DtnSwitch::Instance()->key_dtn_print_info_log_
#define key_dtn_use_net_source        DtnSwitch::Instance()->key_dtn_use_net_source_
#define key_dtn_more_main_ip          DtnSwitch::Instance()->key_dtn_more_main_ip_
#define key_dtn_clean_ipv6            DtnSwitch::Instance()->key_dtn_clean_ipv6_
#define key_dtn_local_dns_filter      DtnSwitch::Instance()->key_dtn_local_dns_filter_
#define key_dtn_enable_tlsv1_3        DtnSwitch::Instance()->key_dtn_enable_tlsv1_3_
#define key_dtn_tlsv1_3_0rtt          DtnSwitch::Instance()->key_dtn_tlsv1_3_0rtt_
#define key_dtn_disable_quic_record   DtnSwitch::Instance()->key_dtn_disable_quic_record_
#define key_dtn_enable_range          DtnSwitch::Instance()->key_dtn_enable_range_
#define key_dtn_ignore_unknown_ssid   DtnSwitch::Instance()->key_dtn_ignore_unknown_ssid_
#define key_dtn_rpt_ln_perf_log       DtnSwitch::Instance()->key_dtn_rpt_ln_perf_log_
#define key_dtn_system_cert_verify    DtnSwitch::Instance()->key_dtn_system_cert_verify_
#define key_dtn_quic_only             DtnSwitch::Instance()->key_dtn_quic_only_
#define key_dtn_quic_support          DtnSwitch::Instance()->key_dtn_quic_support_
#define key_dtn_http2_support         DtnSwitch::Instance()->key_dtn_http2_support_
#define key_dtn_protocol_support      DtnSwitch::Instance()->key_dtn_protocol_support_
#define key_dtn_gm_tls                DtnSwitch::Instance()->key_dtn_gm_tls_
#define key_dtn_save_ticket           DtnSwitch::Instance()->key_dtn_save_ticket_
#define key_dtn_save_ticket_use_mng   DtnSwitch::Instance()->key_dtn_save_ticket_use_mng_
#define val_h1                        DtnSwitch::Instance()->val_h1_
#define val_h12                       DtnSwitch::Instance()->val_h12_
#define val_h123                      DtnSwitch::Instance()->val_h123_
#define val_open                      DtnSwitch::Instance()->val_open_
#define val_close                     DtnSwitch::Instance()->val_close_
#define key_dtn_stay_connections      DtnSwitch::Instance()->key_dtn_stay_connections_
#define key_dtn_netchange_optim       DtnSwitch::Instance()->key_dtn_netchange_optim_
#define key_dtn_enable_net_info       DtnSwitch::Instance()->key_dtn_enable_net_info_
#define key_dtn_enable_req_wait_queue DtnSwitch::Instance()->key_dtn_enable_req_wait_queue_
#define key_dtn_enable_no_body_fix    DtnSwitch::Instance()->key_dtn_enable_no_body_fix_
#define key_dtn_enable_multi_head_fix DtnSwitch::Instance()->key_dtn_enable_multi_head_fix_
#define key_dtn_req_exc_max_count     DtnSwitch::Instance()->key_dtn_req_exc_max_count_
#define key_dtn_group                 DtnSwitch::Instance()->key_dtn_group_
#define key_c_interface               DtnSwitch::Instance()->key_c_interface_
#define key_disable_high_avai_opt     DtnSwitch::Instance()->key_disable_high_avai_opt_
#define key_dtn_domain_converge       DtnSwitch::Instance()->key_dtn_domain_converge_
#define key_dtn_adkl                  DtnSwitch::Instance()->key_dtn_adkl_
#define key_dtn_gwforcehttps          DtnSwitch::Instance()->key_dtn_gwforcehttps_
#define key_dtn_cdnconverge           DtnSwitch::Instance()->key_dtn_cdnconverge_
#define key_dtn_mdnconverge_switch    DtnSwitch::Instance()->key_dtn_mdnconverge_switch_
#define key_dtn_mdnconverge_target    DtnSwitch::Instance()->key_dtn_mdnconverge_target_
#define key_dtn_mdnconverge_hosts     DtnSwitch::Instance()->key_dtn_mdnconverge_hosts_
#define key_dtn_render_alive_time     DtnSwitch::Instance()->key_dtn_render_alive_time_
#define key_dtn_session_alive_time    DtnSwitch::Instance()->key_dtn_session_alive_time_
#define key_dtn_hosts_0rtt            DtnSwitch::Instance()->key_dtn_hosts_0rtt_
#define key_dtn_req_retry_time        DtnSwitch::Instance()->key_dtn_req_retry_time_
#define key_dtn_ret_num_2nd_3rd       DtnSwitch::Instance()->key_dtn_ret_num_2nd_3rd_
#define key_dtn_check_thread_idle     DtnSwitch::Instance()->key_dtn_check_thread_idle_
#define key_dtn_check_cdn_down_status DtnSwitch::Instance()->key_dtn_check_cdn_down_status_
#define key_dtn_fast_clean_thread     DtnSwitch::Instance()->key_dtn_fast_clean_thread_
#define key_dtn_sess_host_ctl         DtnSwitch::Instance()->key_dtn_sess_host_ctl_
#define key_dtn_sess_max_alive_time   DtnSwitch::Instance()->key_dtn_sess_max_alive_time_
#define key_dtn_sess_max_cnt_per_host DtnSwitch::Instance()->key_dtn_sess_max_cnt_per_host_
#define key_dtn_record_h2             DtnSwitch::Instance()->key_dtn_record_h2_
#define key_dtn_fix_exceed_bd         DtnSwitch::Instance()->key_dtn_fix_exceed_bd_
#define key_dtn_third_use_max_fpkg_to DtnSwitch::Instance()->key_dtn_third_use_max_fpkg_to_
#define key_dtn_on_demand_dns         DtnSwitch::Instance()->key_dtn_on_demand_dns_
#define key_dtn_quic_sel_fix          DtnSwitch::Instance()->key_dtn_quic_sel_fix_
}}

#endif /* dtn_switch_h */
