//
// Created by murong on 2021/7/6.
//

#ifndef BIFROST_DTN_ENGINE_H
#define BIFROST_DTN_ENGINE_H

#include <string>
#include <vector>
#include <memory>
#include "url_request.h"

namespace ant_bifrost { namespace dtn {
typedef void* HTTPCookieManager;
typedef void* HTTPCacheManager;
typedef void* ProxyInfo;
typedef std::string DtnPublicKey;
struct URLRequest;
struct ContextParams;

struct DtnEngineParams {
    std::string user_agent;
    bool enable_quic = true;
    std::vector<DtnPublicKey> public_keys;
    //-------预留-------
    ProxyInfo *proxy;
    HTTPCookieManager *cookie_manager;
    HTTPCacheManager  *cache_manager;
};

typedef struct DtnEngineParams* DtnEngineParamsPtr;
typedef enum DTN_ENGINE_RESULT {
    DTN_ENGINE_RESULT_SUCCESS = 0,
    DTN_ENGINE_RESULT_FAIL_PARAMS_ERR,
    DTN_ENGINE_RESULT_FAIL_MEMORY_ERR
} DTN_ENGINE_RESULT;

class DtnEngine {
public:
    DtnEngine() = default;
    virtual ~DtnEngine() = default;
    virtual DTN_ENGINE_RESULT StartEngineWithParams(DtnEngineParamsPtr params) = 0;
    virtual const char *GetVersionString() = 0;
    virtual int32_t StartRequest(const URLRequest& _request) = 0;
    virtual void CancelRequest(int32_t _requestId) = 0;
    virtual void PauseRequest(int32_t _requestId) = 0;
    virtual void ResumeRequest(int32_t _requestId) = 0;
    virtual void PreConnect(const std::vector<ant_bifrost::dtn::ConnectItem>& _items) = 0;
    virtual void OnFgbgChanged(bool _is_fg) = 0;
};


typedef struct DtnEngine * DtnEnginePtr;
const DtnEnginePtr Dtn_Default_Engine();
DtnEnginePtr Dtn_Engine_Create();
bool Dtn_Engine_Destroy(DtnEnginePtr engine);
}}
#endif //BIFROST_DTN_ENGINE_H
