//
//  dtn_comm.hpp
//  dtn
//
//  Created by shuyan on 2018/4/30.
//  Copyright © 2018 shuyan.lxy. All rights reserved.
//

#ifndef dtn_comm_hpp
#define dtn_comm_hpp

#include "dtn_error_code.h"

#include <stdint.h>
#include <string>
#include <vector>
#include <map>

namespace ant_bifrost { namespace dtn {

enum CmdErrType : int32_t;
enum RequestMethod : int32_t;
//==============================================================================
struct DtnTaskResult;
typedef std::vector<std::pair<std::string, std::string>> HeaderFields;
//==============================================================================
#define INIT_STR(n, s) n(s, sizeof(s) - 1)
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
class GlobalConstStr {
public:
    static GlobalConstStr &Instance();
    //--------------------------------------------------------------------------
private:
    GlobalConstStr();
    //--------------------------------------------------------------------------
public:
    const std::string plk_qcid_;
    const std::string plk_q_strm_id_;
    const std::string plk_u_err_code_;
    const std::string plk_pre_u_err_code_;
    const std::string plk_u_err_info_;
    const std::string plk_pre_u_err_info_;
    const std::string plk_retry_;
    const std::string plk_retrycount_;
    const std::string plk_nettunnel_;
    const std::string plk_protocol_;
    const std::string plk_dt_;
    const std::string plk_dns_time_;
    const std::string plk_tcp_time_;
    const std::string plk_tcp_all_time_;
    const std::string plk_tcp_single_time_;
    const std::string plk_tcp_cnt_attempt_;
    const std::string plk_tcp_ip_index_;
    const std::string plk_rtt_time_;
    const std::string plk_start_rtt_time_;
    
    const std::string plk_ssl_time_;
    const std::string plk_channel_select_;
    const std::string plk_inf_dtn_quic_;
    const std::string plk_sos_retry_;
    const std::string plk_dtn_stalled_time_;
    const std::string plk_taskid_;
    const std::string plk_chanl_sel_reason_;
    const std::string plk_pre_chanl_sel_reason_;
    const std::string plk_first_pkg_time_;
    const std::string plk_0rtt_;
    const std::string plk_target_host_;
    const std::string plk_dtn_wait_time_;
    const std::string plk_link_wait_time_;
    const std::string plk_req_wait_time_;
    const std::string plk_req_post_time_;
    const std::string plk_rsp_wait_time_;
    const std::string plk_rsp_gain_time_;
    const std::string plk_start_to_rsp_time_;
    const std::string plk_task_exe_time_;
    const std::string plk_dtn_exe_time_;
    const std::string plk_reuse_link_;
    const std::string plk_conn_wait_time_;
    const std::string plk_raise_thread_pri_;
    const std::string plk_cid_;
    const std::string plk_pre_conn_;
    const std::string plk_0rtt_work_;
    const std::string plk_print_info_log_;
    const std::string plk_try_ipv6_;
    const std::string plk_ipv6_;
    const std::string plk_ip_stack_;
    const std::string plk_dis_quic_record_;
    const std::string plk_range_retry_;
    const std::string plk_range_enable_;
    const std::string plk_channel_transformation_;
    const std::string plk_pkg_timeout_;
    const std::string plk_range_unusable_;
    const std::string plk_len_inconsistent_;
    const std::string plk_accept_range_none_;
    const std::string plk_tls_1_3_;
    const std::string plk_tls_use_ticket_;
    const std::string plk_tls_resumption_;
    const std::string plk_tls_session_clear_;
    const std::string plk_tls_session_expired_;
    const std::string plk_early_data_can_;
    const std::string plk_early_data_send_;
    const std::string plk_early_data_accept_;
    const std::string plk_target_domain_;
    const std::string plk_redirect_count_;
    const std::string plk_local_host_;
    const std::string plk_net_type_;
    const std::string plk_net_name_;
    const std::string plk_subtype_;
    const std::string plk_param1_;
    const std::string plk_param2_;
    const std::string plk_param3_;
    const std::string plk_dtn_ver_;
    const std::string plk_h2c_down_;
    const std::string plk_h2c_;
    const std::string plk_downgrade_to_https_;
    const std::string plk_req_queue_wait_time_;
    const std::string plk_req_wait_count_;
    const std::string plk_req_queue_type_;
    const std::string plk_bi_auth_;
    const std::string plk_cli_cert_cost_;
    const std::string plk_duplicate_head_ct_;
    const std::string plk_raw_url_;
    const std::string plk_biz_type_;
    const std::string plk_tls_use_stm_;
    const std::string plk_tls_stm_errcode_;
    const std::string plk_cli_stm_read_cost_;
    const std::string plk_http_sess_cnt_;
    const std::string plk_quic_sess_cnt_;
    const std::string plk_verify_num_2nd_3rd_;
    const std::string plk_cdn_down_;
    const std::string plk_has_exceed_body_;
    const std::string plk_support_on_demand_dns_;
    const std::string plk_try_on_demand_dns_;
    //--------------------------------------------------------------------------
    const std::string plv_true_;
    const std::string plv_false_;
    const std::string plv_h1h2_;
    const std::string plv_h1_;
    const std::string plv_h2_;
    const std::string plv_quic_;
    const std::string plv_localdns_;
    const std::string plv_httpdns_;
    const std::string plv_code_;
    const std::string plv_msg_;
    const std::string plv_ulib_h2_;
    const std::string plv_ulib_h1_;
    const std::string plv_ulib_quic_;
    const std::string plv_ulib_alpn_;
    const std::string plv_dtn_l_; //小写。
    const std::string plv_dtn_u_; //大写。
    const std::string plv_mass_;
    const std::string plv_mmtp_;
    const std::string plv_fatal_;
    const std::string plv_h2_link_;
    const std::string plv_quic_link_;
    //--------------------------------------------------------------------------
    const std::string hk_h2_;
    const std::string hk_h1_;
    const std::string hk_status_;
    const std::string hk_content_length_;
    const std::string hk_transfer_encoding_;
    const std::string hk_accept_range_;
    //--------------------------------------------------------------------------
    const std::string hv_none_;
    //--------------------------------------------------------------------------
    const std::string nought_; //空字符串。
    const std::string success_;
    const std::string failure_;
    //--------------------------------------------------------------------------
    const std::string gu_poll_fail_;
    const std::string gu_poll_error_;
    const std::string gu_broken_io_;
    const std::string gu_no_io_;
    const std::string gu_bad_io_;
    //--------------------------------------------------------------------------
    const std::string g_domain_0_;
    const std::string g_domain_1_;
    //--------------------------------------------------------------------------
    const std::string g_channel_null_;
    const std::string g_channel_short_;
    const std::string g_channel_long_;
    const std::string g_channel_both_;
    const std::string g_channel_multiplex_;
    const std::string g_channel_quic_multiplex_;
    const std::string g_channel_both_multiplex_;
    const std::string g_channel_both_q_;
    const std::string g_channel_both_q_and_short_;
    const std::string g_channel_both_q_and_multiplex_;
    const std::string g_channel_both_multiplex_and_h1_;
    const std::string g_channel_h1_;
    const std::string g_channel_both_q_multiplex_and_h1_;
    const std::string g_channel_all_;
    //--------------------------------------------------------------------------
    const std::string g_channel_unknown_;
    //--------------------------------------------------------------------------
    const std::string quic_cfg_pre_;
    //--------------------------------------------------------------------------
private:
    static GlobalConstStr *instance_;
};
//==============================================================================
//PL是PerfLog的缩写，即埋点。K是key，V是value。
#define PLK_QCID                   GlobalConstStr::Instance().plk_qcid_
#define PLK_Q_STRM_ID              GlobalConstStr::Instance().plk_q_strm_id_
#define PLK_U_ERR_CODE             GlobalConstStr::Instance().plk_u_err_code_
#define PLK_PRE_U_ERR_CODE         GlobalConstStr::Instance().plk_pre_u_err_code_
#define PLK_U_ERR_INFO             GlobalConstStr::Instance().plk_u_err_info_
#define PLK_PRE_U_ERR_INFO         GlobalConstStr::Instance().plk_pre_u_err_info_
#define PLK_RETRY                  GlobalConstStr::Instance().plk_retry_
#define PLK_RETRYCOUNT             GlobalConstStr::Instance().plk_retrycount_
#define PLK_NETTUNNEL              GlobalConstStr::Instance().plk_nettunnel_
#define PLK_PROTOCOL               GlobalConstStr::Instance().plk_protocol_
#define PLK_DT                     GlobalConstStr::Instance().plk_dt_
#define PLK_DNS_TIME               GlobalConstStr::Instance().plk_dns_time_
#define PLK_TCP_TIME               GlobalConstStr::Instance().plk_tcp_time_
#define PLK_TCP_ALL_TIME           GlobalConstStr::Instance().plk_tcp_all_time_
#define PLK_TCP_SINGLE_TIME        GlobalConstStr::Instance().plk_tcp_single_time_
#define PLK_TCP_CNT_ATTEMPT        GlobalConstStr::Instance().plk_tcp_cnt_attempt_
#define PLK_TCP_CNT_IP_INDEX       GlobalConstStr::Instance().plk_tcp_ip_index_
#define PLK_RTT_TIME               GlobalConstStr::Instance().plk_rtt_time_
#define PLK_START_RTT_TIME         GlobalConstStr::Instance().plk_start_rtt_time_

#define PLK_SSL_TIME               GlobalConstStr::Instance().plk_ssl_time_
#define PLK_CHANNEL_SELECT         GlobalConstStr::Instance().plk_channel_select_
#define PLK_INF_DTN_QUIC           GlobalConstStr::Instance().plk_inf_dtn_quic_
#define PLK_SOS_RETRY              GlobalConstStr::Instance().plk_sos_retry_
#define PLK_DTN_STALLED_TIME       GlobalConstStr::Instance().plk_dtn_stalled_time_
#define PLK_TASKID                 GlobalConstStr::Instance().plk_taskid_
#define PLK_CHANL_SEL_REASON       GlobalConstStr::Instance().plk_chanl_sel_reason_
#define PLK_PRE_CHANL_SEL_REASON   GlobalConstStr::Instance().plk_pre_chanl_sel_reason_
#define PLK_FIRST_PKG_TIME         GlobalConstStr::Instance().plk_first_pkg_time_
#define PLK_0RTT                   GlobalConstStr::Instance().plk_0rtt_
#define PLK_TARGET_HOST            GlobalConstStr::Instance().plk_target_host_
#define PLK_DTN_WAIT_TIME          GlobalConstStr::Instance().plk_dtn_wait_time_
#define PLK_LINK_WAIT_TIME         GlobalConstStr::Instance().plk_link_wait_time_
#define PLK_REQ_WAIT_TIME          GlobalConstStr::Instance().plk_req_wait_time_
#define PLK_REQ_POST_TIME          GlobalConstStr::Instance().plk_req_post_time_
#define PLK_RSP_WAIT_TIME          GlobalConstStr::Instance().plk_rsp_wait_time_
#define PLK_RSP_GAIN_TIME          GlobalConstStr::Instance().plk_rsp_gain_time_
#define PLK_START_TO_RSP_TIME      GlobalConstStr::Instance().plk_start_to_rsp_time_
#define PLK_TASK_EXE_TIME          GlobalConstStr::Instance().plk_task_exe_time_
#define PLK_DTN_EXE_TIME           GlobalConstStr::Instance().plk_dtn_exe_time_
#define PLK_REUSE_LINK             GlobalConstStr::Instance().plk_reuse_link_
#define PLK_CONN_WAIT_TIME         GlobalConstStr::Instance().plk_conn_wait_time_
#define PLK_RAISE_THREAD_PRI       GlobalConstStr::Instance().plk_raise_thread_pri_
#define PLK_CID                    GlobalConstStr::Instance().plk_cid_
#define PLK_PRE_CONN               GlobalConstStr::Instance().plk_pre_conn_
#define PLK_0RTT_WORK              GlobalConstStr::Instance().plk_0rtt_work_
#define PLK_PRINT_INFO_LOG         GlobalConstStr::Instance().plk_print_info_log_
#define PLK_try_IPv6               GlobalConstStr::Instance().plk_try_ipv6_
#define PLK_IPv6                   GlobalConstStr::Instance().plk_ipv6_
#define PLK_IP_STACK               GlobalConstStr::Instance().plk_ip_stack_
#define PLK_DIS_QUIC_RECORD        GlobalConstStr::Instance().plk_dis_quic_record_
#define PLK_RANGE_RETRY            GlobalConstStr::Instance().plk_range_retry_
#define PLK_RANGE_ENABLE           GlobalConstStr::Instance().plk_range_enable_
#define PLK_CHANNEL_TRANSFORMATION GlobalConstStr::Instance().plk_channel_transformation_
#define PLK_PKG_TIMEOUT            GlobalConstStr::Instance().plk_pkg_timeout_
#define PLK_RANGE_UNUSABLE         GlobalConstStr::Instance().plk_range_unusable_
#define PLK_LEN_INCONSISTENT       GlobalConstStr::Instance().plk_len_inconsistent_
#define PLK_ACCEPT_RANGE_NONE      GlobalConstStr::Instance().plk_accept_range_none_
#define PLK_TLS_1_3                GlobalConstStr::Instance().plk_tls_1_3_
#define PLK_TLS_USE_TICKET         GlobalConstStr::Instance().plk_tls_use_ticket_
#define PLK_TLS_RESUMPTION         GlobalConstStr::Instance().plk_tls_resumption_
#define PLK_TLS_SESSION_CLEAR      GlobalConstStr::Instance().plk_tls_session_clear_
#define PLK_TLS_SESSION_EXPIRED    GlobalConstStr::Instance().plk_tls_session_expired_
#define PLK_EARLY_DATA_CAN         GlobalConstStr::Instance().plk_early_data_can_
#define PLK_EARLY_DATA_SEND        GlobalConstStr::Instance().plk_early_data_send_
#define PLK_EARLY_DATA_ACCEPT      GlobalConstStr::Instance().plk_early_data_accept_
#define PLK_TARGET_DOMAIN          GlobalConstStr::Instance().plk_target_domain_
#define PLK_REDIRECT_COUNT         GlobalConstStr::Instance().plk_redirect_count_
#define PLK_LOCAL_HOST             GlobalConstStr::Instance().plk_local_host_
#define PLK_NET_TYPE               GlobalConstStr::Instance().plk_net_type_
#define PLK_NET_NAME               GlobalConstStr::Instance().plk_net_name_
#define PLK_SUBTYPE                GlobalConstStr::Instance().plk_subtype_
#define PLK_PARAM1                 GlobalConstStr::Instance().plk_param1_
#define PLK_PARAM2                 GlobalConstStr::Instance().plk_param2_
#define PLK_PARAM3                 GlobalConstStr::Instance().plk_param3_
#define PLK_DTN_VER                GlobalConstStr::Instance().plk_dtn_ver_
#define PLK_H2C_DOWN               GlobalConstStr::Instance().plk_h2c_down_
#define PLK_H2C                    GlobalConstStr::Instance().plk_h2c_
#define PLK_DOWNGRADE_TO_HTTPS     GlobalConstStr::Instance().plk_downgrade_to_https_
#define PLK_REQ_QUEUE_WAIT_TIME    GlobalConstStr::Instance().plk_req_queue_wait_time_
#define PLK_REQ_WAIT_COUNT         GlobalConstStr::Instance().plk_req_wait_count_
#define PLK_REQ_QUEUE_TYPE         GlobalConstStr::Instance().plk_req_queue_type_
#define PLK_BI_AUTH                GlobalConstStr::Instance().plk_bi_auth_
#define PLK_CLI_CERT_COST          GlobalConstStr::Instance().plk_cli_cert_cost_
#define PLK_DUPLICATE_HEAD_CT      GlobalConstStr::Instance().plk_duplicate_head_ct_
#define PLK_RAW_URL                GlobalConstStr::Instance().plk_raw_url_
#define PLK_BIZ_TYPE               GlobalConstStr::Instance().plk_biz_type_
#define PLK_TLS_USE_STM            GlobalConstStr::Instance().plk_tls_use_stm_
#define PLK_TLS_STM_ERRCODE        GlobalConstStr::Instance().plk_tls_stm_errcode_
#define PLK_CLI_STM_READ_COST      GlobalConstStr::Instance().plk_cli_stm_read_cost_
#define PLK_HTTP_SESS_CNT          GlobalConstStr::Instance().plk_http_sess_cnt_
#define PLK_QUIC_SESS_CNT          GlobalConstStr::Instance().plk_quic_sess_cnt_
#define PLK_VERIFY_NUM_2ND_3RD     GlobalConstStr::Instance().plk_verify_num_2nd_3rd_
#define PLK_CDN_DOWN               GlobalConstStr::Instance().plk_cdn_down_
#define PLK_HAS_EXCEED_BODY        GlobalConstStr::Instance().plk_has_exceed_body_
#define PLK_SUPPORT_ON_DEMAND_DNS  GlobalConstStr::Instance().plk_support_on_demand_dns_
#define PLK_TRY_ON_DEMAND_DNS      GlobalConstStr::Instance().plk_try_on_demand_dns_
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define PLV_TRUE      GlobalConstStr::Instance().plv_true_
#define PLV_FALSE     GlobalConstStr::Instance().plv_false_
#define PLV_H1H2      GlobalConstStr::Instance().plv_h1h2_
#define PLV_H1        GlobalConstStr::Instance().plv_h1_
#define PLV_H2        GlobalConstStr::Instance().plv_h2_
#define PLV_QUIC      GlobalConstStr::Instance().plv_quic_
#define PLV_LOCALDNS  GlobalConstStr::Instance().plv_localdns_
#define PLV_HTTPDNS   GlobalConstStr::Instance().plv_httpdns_
#define PLV_CODE      GlobalConstStr::Instance().plv_code_
#define PLV_MSG       GlobalConstStr::Instance().plv_msg_
#define PLV_ULIB_H1   GlobalConstStr::Instance().plv_ulib_h1_
#define PLV_ULIB_H2   GlobalConstStr::Instance().plv_ulib_h2_
#define PLV_ULIB_QUIC GlobalConstStr::Instance().plv_ulib_quic_
#define PLV_ULIB_ALPN GlobalConstStr::Instance().plv_ulib_alpn_
#define PLV_DTN_L     GlobalConstStr::Instance().plv_dtn_l_
#define PLV_DTN_U     GlobalConstStr::Instance().plv_dtn_u_
#define PLV_MASS      GlobalConstStr::Instance().plv_mass_
#define PLV_MMTP      GlobalConstStr::Instance().plv_mmtp_
#define PLV_FATAL     GlobalConstStr::Instance().plv_fatal_
#define PLV_H2_LINK   GlobalConstStr::Instance().plv_h2_link_
#define PLV_QUIC_LINK GlobalConstStr::Instance().plv_quic_link_
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define HK_H2                GlobalConstStr::Instance().hk_h2_
#define HK_H1                GlobalConstStr::Instance().hk_h1_
#define HK_STATUS            GlobalConstStr::Instance().hk_status_
#define HK_CONTENT_LENGTH    GlobalConstStr::Instance().hk_content_length_
#define HK_TRANSFER_ENCODING GlobalConstStr::Instance().hk_transfer_encoding_
#define HK_ACCEPT_RANGE      GlobalConstStr::Instance().hk_accept_range_
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define HV_NONE GlobalConstStr::Instance().hv_none_
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define NOUGHT  GlobalConstStr::Instance().nought_
#define SUCCESS GlobalConstStr::Instance().success_
#define FAILURE GlobalConstStr::Instance().failure_
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#define GU_POLL_FAIL  GlobalConstStr::Instance().gu_poll_fail_
#define GU_POLL_ERROR GlobalConstStr::Instance().gu_poll_error_
#define GU_BROKEN_IO  GlobalConstStr::Instance().gu_broken_io_
#define GU_NO_IO      GlobalConstStr::Instance().gu_no_io_
#define GU_BAD_IO     GlobalConstStr::Instance().gu_bad_io_
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
enum Channel : int32_t {
    //channel master or channel select
    kChannelNull          = 0x0,
    kChannelShort         = 0x1,
    kChannelLong          = 0x2,
    kChannelMultiplex     = 0x4,
    kChannelQuicMultiplex = 0x8,
    kChannelHttp1x        = 0x10,

    //channel select
    kChannelBoth          = 0x3,
    kChannelBothM         = 0x6, /*Select a channel between the long and multiplex.*/
    kChannelBothQ         = 0xA, /*Select a channel between the long and quic.*/
    kChannelSLQ           = 0xB, /*Select a channel between the long and quic and short.*/
    kChannelMLQ           = 0xE, /*Select a channel between the long and quic and multiplex.*/
    KChannelMH            = 0x14,/*Select a channel between the http2 and http1x*/
    KChannelMHQ           = 0x1C,/*Select a channel between the QUIC http2 and http1x*/
    kChannelAll           = 0x1F, //all of channel
};
//==============================================================================
#define g_channel_null                 GlobalConstStr::Instance().g_channel_null_
#define g_channel_short                GlobalConstStr::Instance().g_channel_short_
#define g_channel_long                 GlobalConstStr::Instance().g_channel_long_
#define g_channel_both                 GlobalConstStr::Instance().g_channel_both_
#define g_channel_multiplex            GlobalConstStr::Instance().g_channel_multiplex_
#define g_channel_quic_multiplex       GlobalConstStr::Instance().g_channel_quic_multiplex_
#define g_channel_both_multiplex       GlobalConstStr::Instance().g_channel_both_multiplex_
#define g_channel_both_q               GlobalConstStr::Instance().g_channel_both_q_
#define g_channel_both_q_and_short     GlobalConstStr::Instance().g_channel_both_q_and_short_
#define g_channel_both_q_and_multiplex GlobalConstStr::Instance().g_channel_both_q_and_multiplex_
#define g_channel_both_multiplex_and_h1 GlobalConstStr::Instance().g_channel_both_multiplex_and_h1_
#define g_channel_both_q_multiplex_and_h1 GlobalConstStr::Instance().g_channel_both_q_multiplex_and_h1_
#define g_channel_h1 				   GlobalConstStr::Instance().g_channel_h1_
#define g_channel_all                  GlobalConstStr::Instance().g_channel_all_

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
extern const std::string &channel_name(int32_t channel);
extern std::string& fill_u_error_code(std::string& _u_err_code_str, int32_t _err_cmd_type, int32_t _err_code);

enum RetryType : int32_t {
    kUnknownType      = 0,
    kTaskRetry        = 1,
    kTaskRangeRetry   = 2,
    kSosRetry         = 3,
    kSosRangeRetry    = 4,
    kNoDataSent       = 5,

};

enum DtnRequestType : int32_t {
    kDefaultDtnRequestType      = 0,
    kH5DtnRequestType           = 1,
    kImgDtnRequestType          = 2,
    kAmrDtnRequestType          = 3,
    kLogDtnRequestType          = 4,
    kVodDtnRequestType          = 5,
    kLiveDtnRequestType         = 6,
    kMAXDtnRequestType          = 7
};

extern const char* const MethodName[];

struct ConnectItem {
    std::string   host;
    uint16_t      port;
};

enum RequestMethod : int32_t { // same to mars/comm/http
    Unknown = 0,
    GET,
    POST,
    OPTIONS,
    HEAD,
    PUT,
    DELETE,
    TRACE,
    CONNECT
};

extern const char* const LocalErrorMessage[];

enum TStreamStat: int32_t {
    kStreamIdle = 0, //表示当前无数据待发送
    kStreamOpen = 1, //表示当前有数据待发送，且部分待发送数据可能未被打包
    kStreamEnd  = 2, //表示当前task不会再有其他数据发送，但仍可以接收数据
    kStreamRst  = 3,
};

struct DtnTaskResult {
    ErrCmdType         error_type;
    int32_t            error_code;
    std::string        error_msg;
    std::map<std::string, std::string>  metrics; //埋点信息
};

enum TaskFailHandleType {
    kTaskFailHandleNormal            = 0,
    kTaskFailHandleNoError           = 0,

    kTaskFailHandleDefault           = -1,
    kTaskFailHandleRetryAllTasks     = -12,
    kTaskFailHandleSessionTimeout    = -13,

    kTaskFailHandleTaskEnd           = -14,
    kTaskFailHandleTaskTimeout       = -15,
    kTaskFailHandleRedirect          = -16,//重定向
    kTaskFailHandleSOSRetry          = -17,

    kTaskFailHandleTaskPause         = -30,
    kTaskFailHandleTaskResume        = -31,
};

}}
#endif /* dtn_comm_hpp */
