//
//  MnetCommonDef.h
//  MANet
//
//  Created by yangxiao on 15/4/15.
//  Copyright (c) 2015年 alipay. All rights reserved.
//
#ifndef MANet_MnetCommonDef_h
#define MANet_MnetCommonDef_h

//#define NEEDLOGSWITCH 1
#include <math.h>
#include "MnetThreadPosixAccess.h"
#include <sstream>
#include <map>
//本类用于日志打印的控制，
class AmnetLogStream {
public:
    static AmnetLogStream& Instance() {
        static AmnetLogStream instance;
        return instance;
    }
    template<class T>
    AmnetLogStream& operator<<(T t) {
#ifdef NEEDLOGSWITCH
        logstream<<t;
#endif
        return *this;
    }
#ifdef NEEDLOGSWITCH
    std::stringstream logstream;
#endif
};

#ifdef NEEDLOGSWITCH

#include <stdio.h>
#include <string.h>
#include <errno.h>

#define debug(...) localDebug(stdout, ## __VA_ARGS__)

#define STRBUILDER AmnetLogStream::Instance()
#define LOG_TO_NS debug(AmnetLogStream::Instance().logstream.str());AmnetLogStream::Instance().logstream.str("")

#else

#define debug(...) (void)0
#define STRBUILDER AmnetLogStream::Instance()
#define LOG_TO_NS (void)0

#endif

#define MAX_MISEC_QUA_RTT 600000

enum amnet_errorno {
    error_unknown = 0,
    error_mem_limited = 1,
    error_kqeueu_create_fail = 2,
    error_unix_socket_create_fail = 3,
    error_command_queue_full = 4,
    error_unix_socket_en_kq_fail = 5,
    error_ssl_context_init_fail = 6,
    error_ssl_handle_init_fail = 7,
    error_socket_create_fail = 8,
    error_udp_dns_fail = 9,
    error_udp_thread_alloc_fail = 10,
    error_session_en_kq_fail = 11,
    error_connect_fail = 12,
    error_config_sys_fail = 13,
    error_timer_en_kq_fail = 14,
    error_bind_ssl_fail = 15,
    error_ssl_handshake_fail = 16,
    error_ssl_ticket_load_fail = 17,
    error_dns_thread_start_fail = 18,
    error_send_data_when_amnet_not_started = 19,
    error_amnet_restart = 20,
    error_hpack_decode_error = 21,
    error_mmtp_head_error = 22,
    error_mmtp_head_zip_type = 23,
    error_unzip_gzip = 24,
    error_event_with_no_socket = 25,
    error_tcp_connect_rsp_error = 26,
    error_ssl_ticket_save_fail = 27,
    error_complated_link_rcv_connect_rsp = 28,
    error_write_fail = 29,
    error_link_closed_by_peer = 30,
    error_link_closed_other = 31,
    error_no_using_link_broken = 32,
    error_unexpect_event = 33,
    error_deque_not_empty_fail = 34,
    error_notice_sock_without_kq = 35,
    error_notice_read_fail = 36,
    error_connect_fail_after_dns = 37,
    error_cannot_find_link_after_dns = 38,
    error_command_type_illegal = 39,
    error_link_break = 40,
    error_DNS_delay_in_queue = 41,
    error_heartBeat_timeout = 42,
    error_rpc_ack_timeout = 43,
    error_net_ok_through_ping = 44,
    error_unknown_tcp_stat = 45,
    error_mmtp_ack_timeout = 46,
    error_soft_link_break = 47,
    error_http_sock_create_fail = 48,
    error_http_request_fail = 49,
    error_http_event_illegal = 50,
    error_http_connect_resp_fail = 51,
    error_http_closed_by_sp = 52,
    error_link_close_client_time_fail = 53,
    error_net_access_type_change = 54,
    error_control_level_break_link = 55,
    error_ssl_switch_change_break = 56,
    error_mmtp_mode_close_break = 57,
    error_ssl_server_cert_error = 58,//no use
    error_delaybreak_status_error = 59,
    error_delaybreak_timer_alloc_fail = 60,
    error_reget_mmtpseq_init_timeout = 61,
    error_backgroud_to_forground_fake_link = 62,
    error_local_socket_bind = 63,
    error_init_ack_timeout = 64,
    error_status_ack_timeout = 65,
    error_thread_block = 66,
    error_init_info_lost = 67,
    error_undecompress_zstd = 68,
    error_compress_zstd = 69,
    error_zstd_unknown_dictionary = 70,
    error_zstd_dictionary_check = 71,
    error_zstd_dictionary_write = 72,
    error_spanner_zstd_unknown_dictionary = 73,
    error_spanner_unknown_zip_type = 74,
    error_spanner_zstd_decompress_error = 75,
    error_spanner_gzip_decompress_error = 76,
    error_bf_notify = 77,
    error_zstd_continue_error = 78,
    error_spanner_hpack_decompress_error = 79,
    error_parse_resp_head_error = 80,
    error_ip_time_to_die = 81,
    error_bifrost_rpc_error = 82,
    error_eagain_error = 83,
    error_en0_error = 84,
    error_socket_pair_blocked = 85,
    error_total_count,
};

//记录上次断连原因 建连日志使用
enum LAST_BREAK_REASON {
    RE_START = 1,  // 启动amnet
    RE_NET_SHIFT = 2,  // 切换网络
    RE_NET_ERR = 3,    // 网络出错
    RE_REMOTE = 4,     // 远端断链
    RE_HB_TO = 5,      // 心跳超时
    RE_RPC_TO = 6,     // 业务超时
    RE_CONN_TO = 7,    // 建连超时
    RE_SSL = 8,        // ssl问题
    RE_RESTRICT = 9,   // 限流重连
    RE_SYS = 10,        // 系统出错
    RE_PROTOCOL = 11,   // 协议处理出错
    RE_INIT_TO = 12,    //init超时
    RE_STATUS_TO = 13,  //status超时
    RE_ZSTD_TO = 14,  //zstd导致的断链
    RE_OTHERS = 99,     // 其它
};

extern const char* amnet_error_message[];

extern const bool errorisNetOrSys[];

extern const char digits[64];


struct PingParam {
    int         threadSeq; //多线程ping时，用来匹配同一线程上的ping请求和ping结果
    std::string host;
    uint16_t    port;
    std::string request;
    unsigned    channelType;
    std::string resultCmpStr;
    unsigned    timeout;
    unsigned    count;
    PingParam(std::string& h,uint16_t p,std::string& req,unsigned ch,std::string& cmpstr,unsigned to,unsigned c):threadSeq(0),
    host(h),port(p),request(req),channelType(ch),resultCmpStr(cmpstr),timeout(to),count(c){}
    PingParam(const PingParam& other){
        threadSeq = other.threadSeq;
        host = other.host;
        port = other.port;
        request = other.request;
        channelType = other.channelType;
        resultCmpStr = other.resultCmpStr;
        timeout = other.timeout;
        count = other.count;
    }
    PingParam& operator=(const PingParam& other) {
        threadSeq = other.threadSeq;
        host = other.host;
        port = other.port;
        request = other.request;
        channelType = other.channelType;
        resultCmpStr = other.resultCmpStr;
        timeout = other.timeout;
        count = other.count;
        return *this;
    }
};

struct PingOnceRes {
    bool        systemError;
    bool        tcpConnectSucc;
    unsigned    tcpConnectCost;
    bool        sslConnectSucc;
    unsigned    sslCost;
    bool        requestSucc;
    unsigned    requestCost;
};

struct PingResult {
    int                         threadSeq;
    std::string                 host;
    uint16_t                    port;
    unsigned                    channelType;
    std::vector<PingOnceRes>    testRes;
};


struct TracerouteParam {
    int         threadSeq;
    std::string host;
    uint16_t port;
    unsigned recvTimeout;
    unsigned maxHops;
    unsigned attemptNum;
    TracerouteParam(std::string& h, uint16_t p)
    :threadSeq(0), host(h), port(p), recvTimeout(5000), maxHops(17), attemptNum(3){}
    TracerouteParam(std::string& h, uint16_t p, unsigned timeout, unsigned hops, unsigned attempts)
    :threadSeq(0), host(h), port(p), recvTimeout(timeout), maxHops(hops), attemptNum(attempts){}
    TracerouteParam(const TracerouteParam& other){
        threadSeq = other.threadSeq;
        host = other.host;
        port = other.port;
        recvTimeout = other.recvTimeout;
        maxHops = other.maxHops;
        attemptNum = other.attemptNum;
    }
    TracerouteParam& operator=(const TracerouteParam& other) {
        threadSeq = other.threadSeq;
        host = other.host;
        port = other.port;
        recvTimeout = other.recvTimeout;
        maxHops = other.maxHops;
        attemptNum = other.attemptNum;
        return *this;
    }
};

struct TraceroutePerHopRes {
    std::string ip;
    unsigned hopNo;
    unsigned hopCost;
    unsigned attemptCount;
};

struct TracerouteResult {
    int                                 threadSeq;
    std::string                         host;
    uint16_t                            port;
    bool                                systemError;
    std::vector<TraceroutePerHopRes>    traceRes;
};

bool getNetCheckPingParamFromDisk(std::string name,std::vector<PingParam>& value);
bool getNetCheckTracerouteParamFromDisk(std::string name, std::vector<TracerouteParam>& value);
bool setNetCheckTracerouteParamIntoDisk(std::string name, std::vector<TracerouteParam>& value);


//包头信息结构体

struct headInfomation {
    unsigned            ver;                //版本
    unsigned            type;               //帧类型
    unsigned            direct;             //方向，客户端上行为0
    unsigned            zipType;            //压缩算法
    uint64_t            mmtpSequence;       //mmtp层序号
    unsigned            dataLen;            //mmtp的body长度
    unsigned            dataChannel;        //数据帧的channel
    unsigned            dataFrameHeadLen;   //数据帧包体里的头部分
    unsigned            serverSequence;     //服务端下行的序列号，客户端需要组包回服务端
    bool                dataThroughSpanner; //数据帧是否需要透过spanner
    uint32_t            forwardIP;          //数据发到spanner过后，spanner找后端服务器直接传给这个ip
    std::string         zstdDictionaryId;   //字典id
    std::map<std::string,std::string> params; //扩展参数
    headInfomation():ver(1),type(0),direct(0),zipType(0),mmtpSequence(0),dataLen(0),dataChannel(0),dataFrameHeadLen(0),serverSequence(0),dataThroughSpanner(true),forwardIP(0){}
};


//response 补偿信息
struct RspCompensateInfo {
    unsigned long   rpcid;
    uint64_t    timestamp;
    uint64_t    seq;
    uint64_t    sendTime;
    RspCompensateInfo(unsigned long did,uint64_t t,uint64_t sq,uint64_t st):rpcid(did),timestamp(t),seq(sq),sendTime(st){}
    RspCompensateInfo(const RspCompensateInfo& other) {
        this->rpcid = other.rpcid;
        this->timestamp = other.timestamp;
        this->seq = other.seq;
        this->sendTime = other.sendTime;
    }
    RspCompensateInfo& operator=(const RspCompensateInfo & other) {
        this->rpcid = other.rpcid;
        this->timestamp = other.timestamp;
        this->seq = other.seq;
        this->sendTime = other.sendTime;
        return *this;
    }
};

struct ScopeMutex {
    ScopeMutex(pthread_mutex_t *mtx) {
        mutex = mtx;
        if(mutex)pthread_mutex_lock(mutex);
    }
    ~ScopeMutex(){
        if(mutex)pthread_mutex_unlock(mutex);
    }
    pthread_mutex_t * mutex;
};

//基本类型到string的转换
template<typename T>
std::string type2str(T t){
    std::ostringstream s;
    s << t;
    return s.str();
}

template<typename T>
T str2type(std::string& s) {
    T i;
    std::istringstream is(s);
    is >> i;
    return i;
}

typedef enum ReconnectTypeEnum {
    RT_reinit = 0,
    RT_reset_seq,
} ReconnectTypeE;

//64进制数转换为10进制数
inline uint64_t Long64To10(std::string& sixLong) {
    uint64_t res = 0;
    char* stringStart = (char*)sixLong.data();
    for (long i = sixLong.length() - 1; i >= 0; i--) {
        char c = stringStart[i];
        uint64_t tmp = 0;
        if (c == '+') {
            tmp = 62;
        } else if (c == '/') {
            tmp = 63;
        } else if (c >= '0' && c <= '9') {
            tmp = c - '0';
        } else if (c >= 'A' && c <= 'Z') {
            tmp = (c - 'A') + 10;
        } else if (c >= 'a' && c <= 'z') {
            tmp = (c - 'a') + 36;
        } else {
            break;
        }
        tmp = pow (64,(sixLong.length() - i -1)) * tmp;
        res += tmp;
    }
    return res;
}

#endif
