//
//  MACtlInterface.h
//  AMNet
//
//  Created by myy on 15/9/15.
//  Copyright (c) 2015年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@class DTNetworkGmClientCertInfo;
@class DTNetworkStdClientCertInfo;

@protocol MACtlInterface <NSObject>

//是否后台不建连 返回yes表示不建连
-(BOOL)BackgroundFetch;
//amnet获取是否wifi或bf状态 此时rpc失败需要过滤掉
-(BOOL)fetchFilter;
//获取sessionid
-(NSString*)getCookieSessionId;
//获取userid
-(NSString*)getUserId;
//获取utdid
-(NSString*)getUtdId;
//国密回调函数，底层查看该host是否支持国密
//域名host是否支持国密双证书，lib_type为1表示STN，为2表示DTN
-(BOOL)checkHostSupportUseGm:(NSString*)host libType:(int)libType;

//设置国密证书
-(DTNetworkGmClientCertInfo*)getGmClientCertInfo:(NSString*) host;

//设置标准证书
-(DTNetworkStdClientCertInfo*)getStdClientCertInfo:(NSString*) host;

@optional

//收到CmdList数据通知管控层
- (void)MAAccessDidRecvCmdListData:(NSData*)dat;

//从管控层获取智能心跳开关
- (BOOL)SmartHearbeatSwitch;

//对某些内部用户，做了名单，这些人如果网络一旦稍有延迟，就启动网络检测
- (BOOL)UserInRadicalNetDetect;

//网络库切换 isDown=true 降级  isDown=false 升级
-(void)changeNetLibray:(BOOL)isDown;

//内存级关闭IPv6开关
-(void)closeIPv6Temporary;

//从设置工具中查看不降级开关
-(BOOL)bifrostNoDowngradeSwitchFromSetting;

@end





