//
//  MAAccess.h
//  Interface
//
//  Created by cuinacai on 15/3/27.
//  Copyright (c) 2015年 cuinacai. All rights reserved.
//
#import <UIKit/UIKit.h>
#import <Foundation/Foundation.h>
#import <APBaseInterfaceAdapter/APBaseInterfaceAdapter.h>
#import "MAStorageDelegate.h"
#import "ManualNetCheckResultInterface.h"
#import "MACtlInterface.h"
#import "QualityModelMgr.h"
#import "MMTPFunStorage.h"
//#import "AMNetAvailbleStatistic.h"

typedef NS_ENUM(NSInteger, MAReconnectRadicalness) {
    MAReconnectRadicalnessNormal = 0,
    MAReconnectRadicalnessSluggish,
    MAReconnectRadicalnessCrazy,
};

typedef NS_ENUM(NSInteger, MATLocalIPStack) {
    MATLocalIPStackNone = 0,
    MATLocalIPStackIPv4 = 1,
    MATLocalIPStackIPv6 = 2,
    MATLocalIPStackDual = 3,
};

@interface AMNetServerAddress : NSObject
/**
 * 给AMNetServerAddress实例赋值
 * @params ip port
 */
+(id)serverAddressIp:(NSString*)ip port:(NSUInteger)port;
/**
 * 给AMNetServerAddress实例赋值
 * @params ip port ttd
 */
+(id)serverAddressIp:(NSString*)ip port:(NSUInteger)port ttd:(long long)ttd;
@property(nonatomic) NSString* ipStr;
@property(nonatomic) NSUInteger port;
@property(nonatomic) long long ttd;

@end

@interface H2AMNetServerAddress : NSObject
/**
 * 给H2AMNetServerAddress实例赋值
 * @params ip port
 */
+(id)h2ServerAddressIp:(NSString*)ip port:(NSUInteger)port;
@property(nonatomic) NSString* h2Ip;
@property(nonatomic) NSUInteger h2Port;

@end

@interface AMNetInitConfig : NSObject
@property (nonatomic) NSString* host;
@property (nonatomic) NSUInteger port;
@property (nonatomic,strong) id<MAStorageDelegate> storage;
@property (nonatomic) NSArray* ipPortList;
@property (nonatomic,weak) NSString* cert;
@property (nonatomic) NSString* h2Host;
@property (nonatomic) NSUInteger h2Port;
@property (nonatomic) NSArray* h2IpPortList;
@property (nonatomic) NSString* quicHost;
@property (nonatomic) NSUInteger quicPort;
@property (nonatomic) BOOL isBifrost;
@property (nonatomic) BOOL isH2Bifrost;
@property (nonatomic) BOOL isDebuggable;

@property (nonatomic) BOOL isStdH2Bifrost;
@property (nonatomic) BOOL isH2Export;
@property (nonatomic) BOOL isH2SSL;
@property (nonatomic) NSString* topCa;
@property (nonatomic) NSString* certName;
@end
#ifdef USE_OLD_MNET
@interface TcpPingConf : NSObject<NSCoding>
@property (nonatomic) NSString* host;
@property (nonatomic) NSUInteger port;
@property (nonatomic) NSString* request;
@property (nonatomic) NSUInteger channel;
@property (nonatomic) NSString* compareString;
@property (nonatomic) NSUInteger timeout;
@property (nonatomic) NSUInteger count;
@end

@interface TracerouteConf : NSObject<NSCoding>
@property (nonatomic) NSString* host;
@property (nonatomic) NSUInteger port;
@property (nonatomic) NSUInteger recvTimeout;
@property (nonatomic) NSUInteger maxHops;
@property (nonatomic) NSUInteger attemptNum;
@end
#endif
@interface MAAccess : NSObject<MAAccessInterface>

@property BOOL started;
@property (strong) NSString* name;
@property NSThread* workThread;
@property (nonatomic) BOOL  linkRestrict;                       //连接是否被限制，削峰
@property NSString* restrictionMemo;                            //削峰提示信息
@property (nonatomic) BOOL needNetcheckButton;                  //是否需要绘制网络检测的按钮

@property (nonatomic) BOOL shortLinkChannelOpen;                //短连接是否开
@property (nonatomic) NSString* mTag;                           //rpc异常标识

@property (nonatomic) BOOL netCardIpV6Only;

@property (nonatomic) BOOL isLaunchFinised;                     //框架启动完成 可进行耗时操作

@property (atomic) BOOL bifrostLoaded;

//@property(nonatomic) AMNetAvailbleStatistic* availbleStatistic; //可用性统计

@property (nonatomic) BOOL isBackground;

/**
获取统一库Client IP，返回结果可能空
@return ClientIP 返回结果可能为空、ipV4地址、ipV6地址
*/
@property(atomic,strong,readonly) NSString *clientIP;

/**
 * 获得单例
 */
+(instancetype)shareInstance;

/**
 *    @brief    初始化
 *
 *    @param     host         host
 *  @param     ip             有可能为空值
 *    @param     port         端口
 *    @param     storage     MAStorageDelegate的实现
 *
 *    @return instance
 */
-(void)startAMNetThread:(AMNetInitConfig*)config;

/**
 *  关闭AMNet网络模块
 */
-(void)stopAMNetThread;
/**
 *  断掉现在的AMNet长连接
 */
-(void)breakAMNetLongLink;

/**
 *	@brief	注册数据回调
 *
 *	@param 	obj 	    head
 *	@param 	channel     目前有RPC或者SYNC
 *
 *	@return
 */
-(void)registerDataObserver:(id<MADataInterface>)obj channel:(MAChannel)channel;

/**
 *  @brief	注册和管控层交互的回调
 */
-(void)registerCtlObserver:(id<MACtlInterface>)obj;


/**
 *	@brief	错误监听
 *
 *	@param 	errorObserver     MAErrorInterface实现
 *
 *	@return
 */
-(void)addErrorObserver:(id<MAErrorInterface>)errorObserver;
/**
 *	@brief	info提供者
 *
 *	@param 	infoObject     MAInitInfoInterface实现
 *
 *	@return
 */
-(void)addInfoProvider:(id<MAInitInfoInterface>)infoProvider;
/**
 *	@brief	状态变化监听
 *
 *	@param 	statusObserver     MAStatusInterface实现
 *
 *	@return
 */
-(void)addStatusObserver:(id<MAStatusInterface>)statusObserver;
/**
 *	@brief	查询MAccess的状态
 *
 *	@return MAAccessStatus
 */
-(MAAccessStatus)accessStatus;
/**
 *	@brief	网络信息提供者
 *
 *	@param 	netInfoProvider     NetAccessInfo实现
 *
 *	@return
 */
-(void)registerNetInfoProvider:(id<NetAccessInfo>)netInfoProvider;
/**
 *	@brief	打日志的提供者
 *
 *	@param 	LogWriter     AMLogDelegate实现
 *
 *	@return
 */
-(void)registerLogWriter:(id<AMLogDelegate>)lw;

/**
 *  发送消息，带消息id
 *
 *  @param head    消息头key-value对
 *  @param body    消息体
 *  @param channel 消息业务类型
 *  @param dataId  数据id
 *  @param passSP  是否需要spanner转发
 */
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId;
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt;
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt forwardIP:(UInt32)fip;
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt canHttp:(BOOL)canHttp;
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt forwardIP:(UInt32)fip canHttp:(BOOL)canHttp;
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt canHttp:(BOOL)canHttp canZstd:(BOOL)canZstd;
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt forwardIP:(UInt32)fip canHttp:(BOOL)canHttp canZstd:(BOOL)canZstd;

-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt forwardIP:(UInt32)fip canHttp:(BOOL)canHttp canZstd:(BOOL)canZstd extraParams:(NSDictionary*)extraParams;

/**
 *  sync 读扩散使用
 *
 *  @param head    消息头key-value对
 *  @param body    消息体
 *  @param channel 消息业务类型
 *  @param dataId  数据id
 *  @param passSP  是否需要spanner转发
 *  @param nrt     是否可重试
 *  @param fip     forwardIP
 *  @param params  扩展参数
 */
-(void)sendHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)channel dataId:(NSUInteger)dataId passSpanner:(BOOL)passSP needRetry:(BOOL)nrt forwardIP:(UInt32)fip params:(NSDictionary*)params;

-(void)sendData:(NSData*)data channel:(MAChannel)channel passSpanner:(BOOL)passSP;
/**
 *  仅通过短连接发送数据
 *
 *  @param head   头k-v对
 *  @param body   体
 *  @param ch     通道号
 *  @param dataId 数据编号
 *  @param passSp 是否要spanner转发
 *  @param fip    是否让spanner转到固定后端ip
 */
-(void)sendThroughHttpHead:(NSDictionary*)head body:(NSData*)body channel:(MAChannel)ch dataId:(NSUInteger)dataId passSpanner:(BOOL)passSp forwardIP:(UInt32)fip;

/**
 *  管控层向服务端发送的包
 *
 *  @param pkg 管控层发送的数据
 */
-(void)networkCtlPkgSend:(NSData*)pkg;
/**
 *  登陆的信息通知
 *
 *  @param isIn 登入或登出
 *  @param uid  用户ID，登出不填
 *  @param sid  sid，登出不填
 */
-(void)userLogInOut:(BOOL)isIn userId:(NSString*)uid cachedSessionId:(NSString*)sid;
/**
 *  携带扩展参数登陆的信息通知
 *
 *  @param isIn 登入或登出
 *  @param uid  用户ID，登出不填
 *  @param sid  sid，登出不填
 *  @param extInfo  扩展参数，登出不填
 */
-(void)userLogInOut:(BOOL)isIn userId:(NSString*)uid cachedSessionId:(NSString*)sid extInfo:(NSDictionary*)extInfo;
/**
 *  取消发送过的消息
 *
 *  @param dataId 数据ID，对应于发送时的id
 */
-(void)cancelData:(NSUInteger)dataId;

/**
 *  长连接的地址信息通知，iplist中的每个值为AMNetServerAddress类型
 *
 *  @param host   域名
 *  @param port   端口
 *  @param iplist ip-port 列表 对应于init的信息
 */
-(void)longLinkHost:(NSString*)host port:(NSUInteger)port iplist:(NSArray*)iplist;

/**
 *  http短连接地址通知，iplist中的每个值为NSString，仅ip无port
 *
 *  @param host   域名
 *  @param iplist ip列表,NSString队列
  *  @param port  端口
 */
-(void)httpHost:(NSString*)host ipList:(NSArray*)iplist andPort:(unsigned)port;

/**
 *  http短连接地址通知，iplist中的每个值为NSString，仅ip无port
 *
 *  @param host   域名
 *  @param iplist ip列表,NSString队列
 *  @param port  端口
 *  @param ttd  过期时间 1970.1.1至今
 */
-(void)httpHost:(NSString*)host ipList:(NSArray*)iplist andPort:(unsigned)port ttd:(long long)ttd;

/**
 *  建连和重连策略的方式，以及重连的激进程度
 *
 *  @param pattern 建连的方式
 *  @param radical 建连的激进程度
 */
-(void)reconnectLinerCount:(NSUInteger)lc radicalness:(MAReconnectRadicalness)radical;

/**
 *  设置多少次开始尝试使用多网卡建连
 *
 *  @param multiStart 
 */
-(void)setMultipleEthChooseStartCount:(NSInteger)multiStart;

//辅助---------------------------------------------------------------------------------------------------------
//收到数据包的回调 ,超时传秒
-(void)dataAckNotice:(NSUInteger)dataId isTimeOut:(BOOL)istimeout timeoutInternal:(NSInteger)tout;
/**
 *  设置是否使用openssl开关
 *
 *  @param yes or no
 */
-(void)noticeUseNewOpenssl:(BOOL)use;
/**
 *  设置是否开启短频建连开关
 *
 *  @param yes or no
 */
-(void)noticeShortFrequencySwitch:(BOOL)use grayStr:(NSString*)str;
/**
 *  设置是否开启短连接开关
 *
 *  @param yes or no
 */
-(void)noticeHttpShortChannelSwitch:(BOOL)use grayStr:(NSString*)str;

/**
 *  设置是否开启rpc重试开关
 *
 *  @param yes or no
 */
-(void)noticeRPCRetrySwitch:(BOOL)use;

/**
 *  设置是否开启st回包超时处理逻辑开关
 *
 *  @param yes or no
 */
-(void)noticeStatusTimerSwitch:(BOOL)use grayStr:(NSString*)str;
/**
 *  设置短连接超时时长
 *  @param 时长  单位s
 */
-(void)setShortChannelTimeoutConfig:(NSUInteger)sctc;
/**
 * 框架发送后台暂停通知开关
 */
-(void)setBackgroudNoticeChagne:(BOOL)noticeChange;
/**
 *  能否网络检测
 */
-(BOOL)canNetCheck;//老链路就返回NO
/**
 * 网络检测接口
 * @param 参数为结果回调的对象
 */
-(void)startNetCheckWithcallbackItem:(id<ManualNetCheckResultInterface>)cbItem;
/**
 *  取消网络检测
 */
-(void)cancelNetCheck;
/**
 *  将v4地址转成v6地址
 *  @param 要转换的v4地址
 */
-(NSString*)getIpV6OxcStringFromPointSepIpV4:(NSString*)v4;
/**
 *  刷新网卡信息
 */
-(void)freshNetInterfacefInfo;
/**
 *  设置使用v6的判断开关
 */
-(void)setUsingIpV6JudgeLogic:(BOOL)use;
/**
 * 设置是否合包开关
 */
-(void)setComposeSwitch:(BOOL)use;
/**
 * 设置ab_tag
 * @params  abDict 相关abtest的开关值
 * @params  isHit 64，64，32是否命中 只埋点时用
 */
-(void)setAbTag:(NSString*)abTagStr hit:(bool)isHit;
/**
 * 设置配置接口
 * @params  管控层传递的storage实例
 */
-(void)updateStorage:(id<MAStorageDelegate>)storage;
/**
 *  通过管控层设置所有新增功能的开关
 *
 *  @param funDict 字典类型 包括了所有新功能的开关
 */
-(void)updateNewFunctionSwitch:(NSDictionary*)funDict;
/**
 *  设置质量模型评级的相关参数
 *
 *  @param qosDict 字典类型 包括了相关参数
 */
-(void)updateQosConfig:(NSDictionary*)qosDict;
/**
 * 外部调用 获取最终网络质量评级
 */
-(QOSLEVEL)getQosLevel;
/**
 * 设置zstd灰度开关
 */
-(void)noticeZstdGraySwitch:(BOOL)use grayStr:(NSString*)str;
/**
 * 设置zstd是否需要spanner鉴定开关
 */
-(void)noticeZstdSpannerSwitch:(BOOL)use;
/**
 * 设置zstd降级后升级间隔 默认7200
 */
-(void)noticeZstdUpgradeInternal:(NSUInteger)internal;

/**
 *  专为httpdns制作的同步接口，st是头部返回码，ec是错误码
    错误码表：
        -1  创建socket失败
        -2  ipv6环境绑定本地网卡失败
        -3  dns失败
        -4  设置socket 建连非阻塞失败
        -5  设置socket 建连非阻塞失败2
        -6  tcp建连错误
        -7  设置读写超时时失败
        -8  socket send()失败，包括超时和其他错误，具体原因要查errno
        -9  socket read()失败，包括超时和其他错误，具体原因要查errno
        -10 tcp建连超时
 */
-(NSData*)SyncSocketSendAndRcvHost:(NSString*)h port:(UInt16)port dataToSend:(NSData*)d timeoutSec:(NSInteger)tm errCode:(NSInteger*)ec;
//管控层获取mtag
-(NSString*)getMTAG;

//管控层获取qos信息
-(NSString*)getQOSInfo;

/**
 网络是否可用

 @return YES 代表有网络  NO 代表网络不可用
 */
-(BOOL)netAccess;

///////////////////////////////统一库相关接口/////////////////////////////////////
/**
 * 设置bifrost开关 使用统一库还是旧库 
 */
-(void)noticeBifrostSwitch:(BOOL)use useH2:(BOOL)useH2;
/**
 *  通过管控层设置所有统一库的开关
 *
 *  @param funDict 字典类型 包括了所有新功能的开关
 */
-(void)updateBifrostSwitch:(NSDictionary*)bifDict;
/**
 *  关闭bifrost网络模块
 */
-(void)stopBifrostThread;
/**
 *  是否使用bifrost
 */
-(BOOL)isBifrost;
/**
 *  h2的地址信息通知，iplist中的每个值为H2AMNetServerAddress类型
 *
 *  @param host   域名
 *  @param port   端口
 *  @param iplist ip-port 列表 对应于init的信息
 */
-(void)h2LinkHost:(NSString*)host port:(NSUInteger)port iplist:(NSArray*)iplist;
/**
 *  rpc埋点 获取统一库埋点
 *
 *  @param host   域名
 */
-(void)bifrostFlag:(NSMutableDictionary *)dict;

/**
 * 初始化bifrost，日志、存储、app信息模块
 */
-(void)bifrostInit;

/**
 * 反初始化Bifrost
 */
-(void) uninitBifrost;

/**
 延迟注册atexit
 */
-(void) delayRegisterAtExitCallback:(AMNetInitConfig*)config;

/**
 * 激活统一库
 */
- (void)activateBifrost:(AMNetInitConfig *)config;

//获取tcp connect info
- (NSMutableDictionary*) getTcpConnectInfos;

/**
 * 查看是否处于降级时间内，10.1.87新增函数，指http2_target降级到mmtp_target
 */
-(BOOL)isBifrostH2InDowngrade;

/**
 * 执行降级操作，10.1.87新增函数，指http2_target降级到mmtp_target
 */
-(void)downgradeBifrost:(NSString*)downgradeType;

/**
 * 查看当前是否正在使用http2长连接
 */
-(BOOL)isNowUsingBifrostH2Longlink;
//这里开个接口，为了networkctrlservice模块能调用到
-(BOOL)isDisableBifrostRpcDowngrade;

-(void)notifyBifrostLaunchFinised;


-(MATLocalIPStack)localIPStackDetect;

-(void)notifySuccessRpc:(long long)rpcId withChannelSelected:(NSString*)channelSelected;
/**
同步执行block，并且检测这个block执行是否ANR并打印日志，可能会抛异常需要try-catch
@param block 执行的block
@param timeout 检测ANR超时时间，超过这个时间未执行就算ARN，单位ms
@param file 文件
@param func 函数
@param line 行数
@param identify 标志id
@return void
*/
+(void)executeBlockSync:(void (^)())block checkAnrTime:(int)timeout file:(NSString*)file func:(NSString*)func line:(int)line identify:(int)identify;

/**
 * 保存当前流量
 */
+(void)savelTraffic:(uint64_t)taskId;

/**
 * rto评估
 */
+(void)updateEstimate:(double)rtt;

/**
 *回包时计算dataid对应的流量
 */
+(void)calculateTrafficSpeed:(uint64_t)taskId time:(double)time;
@end

@interface MAAccessCallBack : NSObject
+(DTNetworkGmClientCertInfo*)getGmClientCertInfo:(NSString*)host;
+(DTNetworkStdClientCertInfo*)getStdClientCertInfo:(NSString*)host;
+(NSData*) encryptString:(NSData*) originalStr;
+(NSData*) decryptString:(NSData*) encryptStr;
+(NSString*)getOutCache;
@end

