/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.demo;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.BucketInfo;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class HelloOSS {
    static Logger logger = Logger.getLogger(HelloOSS.class);
    private static String endpoint = "http://oss-cn-hangzhou.aliyuncs.com";
    private static String accessKeyId = "<yourAccessKeyId>";
    private static String accessKeySecret = "<yourAccessKeySecret>";
    private static String bucketName = "<yourBucketName>";
    private static String firstKey = "my-first-key";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PropertyConfigurator.configure("conf/log4j.properties");
        logger.info("Started");
        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
        try {
            String line;
            if (ossClient.doesBucketExist(bucketName)) {
                System.out.println("\u60a8\u5df2\u7ecf\u521b\u5efaBucket\uff1a" + bucketName + "\u3002");
            } else {
                System.out.println("\u60a8\u7684Bucket\u4e0d\u5b58\u5728\uff0c\u521b\u5efaBucket\uff1a" + bucketName + "\u3002");
                ossClient.createBucket(bucketName);
            }
            BucketInfo info = ossClient.getBucketInfo(bucketName);
            System.out.println("Bucket " + bucketName + "\u7684\u4fe1\u606f\u5982\u4e0b\uff1a");
            System.out.println("\t\u6570\u636e\u4e2d\u5fc3\uff1a" + info.getBucket().getLocation());
            System.out.println("\t\u521b\u5efa\u65f6\u95f4\uff1a" + info.getBucket().getCreationDate());
            System.out.println("\t\u7528\u6237\u6807\u5fd7\uff1a" + info.getBucket().getOwner());
            ByteArrayInputStream is = new ByteArrayInputStream("Hello OSS".getBytes());
            ossClient.putObject(bucketName, firstKey, is);
            System.out.println("Object\uff1a" + firstKey + "\u5b58\u5165OSS\u6210\u529f\u3002");
            OSSObject ossObject = ossClient.getObject(bucketName, firstKey);
            InputStream inputStream = ossObject.getObjectContent();
            StringBuilder objectContent = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = reader.readLine()) != null) {
                objectContent.append(line);
            }
            inputStream.close();
            System.out.println("Object\uff1a" + firstKey + "\u7684\u5185\u5bb9\u662f\uff1a" + objectContent);
            String fileKey = "README.md";
            ossClient.putObject(bucketName, fileKey, new File("README.md"));
            System.out.println("Object\uff1a" + fileKey + "\u5b58\u5165OSS\u6210\u529f\u3002");
            ObjectListing objectListing = ossClient.listObjects(bucketName);
            List<OSSObjectSummary> objectSummary = objectListing.getObjectSummaries();
            System.out.println("\u60a8\u6709\u4ee5\u4e0bObject\uff1a");
            for (OSSObjectSummary object : objectSummary) {
                System.out.println("\t" + object.getKey());
            }
            ossClient.deleteObject(bucketName, firstKey);
            System.out.println("\u5220\u9664Object\uff1a" + firstKey + "\u6210\u529f\u3002");
            ossClient.deleteObject(bucketName, fileKey);
            System.out.println("\u5220\u9664Object\uff1a" + fileKey + "\u6210\u529f\u3002");
        }
        catch (OSSException oe) {
            oe.printStackTrace();
        }
        catch (ClientException ce) {
            ce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ossClient.shutdown();
        }
        logger.info("Completed");
    }
}

