from flask import Flask, render_template

app = Flask(__name__)

products = [
    {"id": 1, "name": "Product A", "price": 10.0},
    {"id": 2, "name": "Product B", "price": 20.0},
    {"id": 3, "name": "Product C", "price": 30.0}
]

cart = []

@app.route('/')
def product_page():
    return render_template('products.html', products=products)

@app.route('/cart')
def cart_page():
    total = sum(item['price'] for item in cart)
    return render_template('cart.html', cart=cart, total=total)

@app.route('/checkout')
def checkout():
    return render_template('checkout.html')

if __name__ == '__main__':
    app.run(debug=True)
