#!/bin/bash
set -x
echo "link_and_sign.sh"
echo "para0:$0"
echo "para1:$1"
echo "para2:$2"
echo "para3:$3"

BasePath=$(cd `dirname $0`; pwd)
mmTARGET_BUILD_DIR=$1
mmFRAMEWORKS_FOLDER_PATH=$2
mmsign_id=$3
if [ -z "$mmTARGET_BUILD_DIR" ];then
    echo "\$mmTARGET_BUILD_DIR is empty"
    mmTARGET_BUILD_DIR=${TARGET_BUILD_DIR}
fi
if [ -z "$mmFRAMEWORKS_FOLDER_PATH" ];then
    echo "\$mmFRAMEWORKS_FOLDER_PATH is empty"
    mmFRAMEWORKS_FOLDER_PATH=${FRAMEWORKS_FOLDER_PATH}
fi
if [ -z "$mmsign_id" ];then
    echo "\$mmsign_id is empty"
    mmsign_id=${EXPANDED_CODE_SIGN_IDENTITY}
fi
ASP_SDK=${TARGET_BUILD_DIR}/${FRAMEWORKS_FOLDER_PATH}/ASPEngineSDK.framework
ASP_SDK_Frameworks=${ASP_SDK}/Frameworks
if [ -d "${ASP_SDK_Frameworks}" ];then
    cp -a ${ASP_SDK_Frameworks}/* ${mmTARGET_BUILD_DIR}/${mmFRAMEWORKS_FOLDER_PATH}
else
    cp -a ${BasePath}/../../* ${mmTARGET_BUILD_DIR}/${mmFRAMEWORKS_FOLDER_PATH}
    cp -a ${ASP_SDK_Frameworks}/* ${mmTARGET_BUILD_DIR}/${mmFRAMEWORKS_FOLDER_PATH}
fi

for  file in  ${ASP_SDK_Frameworks}/*
do
     if  test -d $file
     then
         filenameext=${file##*/};
         filename=${filenameext%.*}
         array_name+=($filename)
     fi
done

if [ -d "${ASP_SDK_Frameworks}" ];then
    rm -fr ${ASP_SDK_Frameworks}
fi

mmbuild_sdk_sh=${ASP_SDK}/link_and_sign.sh
if [ -e "${mmbuild_sdk_sh}" ];then
    rm -fr ${mmbuild_sdk_sh}
fi

for element in ${array_name[@]}
do
codesign -f -s "${mmsign_id}" ${mmTARGET_BUILD_DIR}/${mmFRAMEWORKS_FOLDER_PATH}/${element}.framework/${element}
done

codesign -f -s "${mmsign_id}" ${mmTARGET_BUILD_DIR}/${mmFRAMEWORKS_FOLDER_PATH}/ASPEngineSDK.framework/ASPEngineSDK

echo "link and sign dylib end."
