//
//  ASPStreamView.h
//  aspdemo
//
//  Created by 杨航涛 on 2022/1/12.
//

#import <UIKit/UIKit.h>
#import "ASPEngineSDK.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, ASPScaleType) {
    ASPScaleTypeFill,
    ASPScaleTypeFit
};

@interface ASPStreamView : UIView

+ (instancetype)buildStreamView;

@property (nonatomic, assign) BOOL enableDump;

- (void)startWithTicket:(ASPConnTicket*) ticketParam;

- (void)start:(ASPConnParam*) connParam;

- (int)stop;

- (void)dispose;

- (void)enableDesktopMode:(BOOL)enabled;

- (void)enableDesktopGesture:(BOOL)enabled;

- (BOOL)enableStatistics:(BOOL) enabled;

- (BOOL)sendKeyboardEvent: (ASPKeyEvent) event;

- (BOOL)simulateMouseClick:(BOOL)leftButton;
- (BOOL)simulateMouseClick:(BOOL)leftButton x:(float)x y:(float)y;

@property (nonatomic, weak) id<ASPEngineDelegate> engineDelegate;
@property (nonatomic, weak) id<ASPEngineResolutionUpdateDelegate> resolutionUpdateDelegate;
@property (nonatomic, weak) id<ASPEngineCursorDelegate> cursorDelegate;
@property (nonatomic, weak) id<ASPEngineOrientationUpdateDelegate> orientationUpdateDelegate;
@property (nonatomic, weak) id<ASPEngineStatisticsDelegate> statisticsDelegate;
@property (nonatomic, weak) id<ASPEngineIMEDelegate> imeDelegate;
@property (nonatomic, weak) id<ASPWindowViewDelegate> windowViewDelegate;

+ (void)setASPEngineLogDelegate:(id<ASPEngineLogDelegate>)delegate;
+ (void)unsetASPEngineLogDelegate;

- (BOOL)enableMouseMode:(BOOL)enabled;
- (void)hideCursor;
- (void)showCursor;

- (void)setMaxSupportedVideoResolutionSize:(CGSize)size;
- (void)setVideoProfileWithWidth:(int)width
                          height:(int)height
                             fps:(int)fps;
- (void)enableSR:(BOOL) enable;

@property (nonatomic, assign) BOOL mute;
@property (nonatomic, assign) ASPScaleType scaleType;

@property (nonatomic, assign) BOOL enableTouchFeel;

// IME
@property (nonatomic, assign) BOOL isImeFocus;
- (void)showImeKeyboard;
- (void)hideImeKeyboard;
@property (nonatomic, readonly, assign) BOOL isShowImeKeyboard;

@end

NS_ASSUME_NONNULL_END
