//
//  ViewController.m
//  aspdemo
//
//  Created by hang su on 2021/10/21.
//

#import "LoginViewController.h"

#import <AVFoundation/AVSampleBufferDisplayLayer.h>
#import "AccountHelper.h"
#import "DesktopListViewController.h"

#pragma mark --LoginViewController定义
@interface LoginViewController () {
    NSString* mUrl;
    NSString* mBaseParams;
    NSString* mSessionId;
    NSString* mLoginToken;
}
@property (nonatomic, strong) AccountHelper* accountHelper;

@property (weak, nonatomic) IBOutlet UITextField *region;
@property (weak, nonatomic) IBOutlet UITextField *workspaceId;
@property (weak, nonatomic) IBOutlet UITextField *userName;
@property (weak, nonatomic) IBOutlet UITextField *userPwd;
@property (weak, nonatomic) IBOutlet UIButton *loginBtn;


- (NSString*)getUtcTimeStamp;

- (NSMutableArray*)parseDesktopList:(NSDictionary*) jsonData;
- (NSDictionary*)parseTicket:(NSString*)ticket;
- (void) getDesktopList:(UserInfo*)userInfo;
- (void) requestDesktopList;

- (void)requestNetwork;

@end

#pragma mark --LoginViewController实现
@implementation LoginViewController

- (NSString*)getUtcTimeStamp {
    NSDate *currentDate = [NSDate date];//获取当前时间，日期，当前系统时区
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];// 创建一个时间格式化对象
    [dateFormatter setDateFormat:@"yyyy-MM-dd'T'HH:mm:ss'Z'"];//设定时间格式,这里可以设置成自己需要的格式  2021-11-19T09:55:35Z
    NSTimeZone* zone = [NSTimeZone systemTimeZone]; //获取系统的时区
    NSTimeInterval timeDiff = [zone secondsFromGMTForDate:currentDate]; //8小时
    timeDiff = 0 - timeDiff;
    NSDate* newDate = [currentDate dateByAddingTimeInterval:timeDiff]; //将当前时间减去8小时得到UTC的时间
    NSString* timestamp = [dateFormatter stringFromDate:newDate]; //将时间转化成字符串
    return timestamp;
}

-(NSMutableArray*)parseDesktopList:(NSDictionary *)jsonData {
    NSArray* desktopArray = jsonData[@"Desktops"];
    NSMutableArray* desktops = [[NSMutableArray alloc]init];
    for (NSDictionary* element in desktopArray) {
        CloudDesktop* desktop = [[CloudDesktop alloc]init];
        desktop.chargeType = element[@"ChargeType"];
        desktop.connectionStatus = element[@"ConnectionStatus"];
        desktop.desktopId = element[@"DesktopId"];
        desktop.desktopName = element[@"DesktopName"];
        desktop.desktopStatus = element[@"DesktopStatus"];
        desktop.expiredTime = element[@"ExpiredTime"];
        desktop.osType = element[@"OsType"];
        desktop.protocolType = element[@"ProtocolType"];
        [desktops addObject:desktop];
    }
    return desktops;
}

- (void)viewDidLoad {
    NSLog(@"LoginViewController viewDidLoad");
    
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self requestNetwork];
}

-(void) getDesktopList:(UserInfo*)userInfo {
    // getLoginToken
    NSMutableString* params = [[NSMutableString alloc]init];
    NSMutableString* officeSiteId = [[NSMutableString alloc]init];
    NSString* site = [[NSString alloc] initWithFormat:@"http://ecd.%@.aliyuncs.com", userInfo.region];
    self->mUrl = [NSString stringWithString:site];
    
    NSString* clientId = @"Client1231";
    NSString* clientOS = @"iOS";
    NSString* clientVersion = @"1.0.0";
    [officeSiteId appendFormat:@"%@+dir-%@", userInfo.region, userInfo.workspaceId];
    NSString* format = @"json";
    NSString* signatureNonce = [NSString stringWithFormat:@"%u", arc4random()];
    NSString* timestamp = [self getUtcTimeStamp];
    NSString* version = @"2020-10-02";
    NSString* product = @"ecs_ad";
    NSString* action = @"GetLoginToken";
    NSString* currentStage = @"ADPassword";
    NSString* endUserId = userInfo.userName;
    NSString* password = userInfo.userPwd;
    
    [params appendFormat:@"?ClientId=%@", clientId];
    [params appendFormat:@"&ClientOS=%@", clientOS];
    [params appendFormat:@"&ClientVersion=%@", clientVersion];
    [params appendFormat:@"&OfficeSiteId=%@", officeSiteId];
    [params appendFormat:@"&Format=%@", format];
    [params appendFormat:@"&RegionId=%@", userInfo.region];
    [params appendFormat:@"&SignatureNonce=%@", signatureNonce];
    [params appendFormat:@"&Timestamp=%@", timestamp];
    [params appendFormat:@"&Version=%@", version];
    [params appendFormat:@"&product=%@", product];
    self->mBaseParams = [NSString stringWithString:params];
    [params appendFormat:@"&Action=%@", action];
    [params appendFormat:@"&CurrentStage=%@", currentStage];
    [params appendFormat:@"&EndUserId=%@", endUserId];
    [params appendFormat:@"&Password=%@", password];
    
    NSString* requestUrl = [[NSString alloc] initWithFormat:@"%@%@", site, params];
    requestUrl = [requestUrl stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet characterSetWithCharactersInString:@"#%<>[\\]^`{|}\"]+"].invertedSet];
    NSLog(@"requestUrl=%@", requestUrl);
    
    
    NSURL* url = [NSURL URLWithString:requestUrl];
    NSURLRequest* request = [[NSURLRequest alloc]initWithURL:url];
    
    NSURLSession* session = [NSURLSession sharedSession];
    NSURLSessionDataTask* task = [session dataTaskWithRequest:request completionHandler:
        ^(NSData* data, NSURLResponse* response, NSError* error){
        NSLog(@"账号登录请求Token完成");
        if(!error) {
            NSHTTPURLResponse* httpResponse = (NSHTTPURLResponse*) response;
            NSLog(@"statusCode:%zd", httpResponse.statusCode); //200 if success
            if (httpResponse.statusCode == 200) {
                NSDictionary *resDict = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingFragmentsAllowed error:nil];
                // TODO delete useless log
                for (NSString *key in resDict) {
                    id value = resDict[key];
                    NSLog(@"%@:%@", key, value);
                }
                self->mSessionId = [NSString stringWithFormat:@"%@", resDict[@"SessionId"]];
                self->mLoginToken = [NSString stringWithFormat:@"%@", resDict[@"LoginToken"]];
                NSLog(@"LoginToken=%@, SessionId=%@", self->mLoginToken, self->mSessionId);
                [self requestDesktopList];
            } else {
                NSLog(@"GetLoginToken return statusCode  error:%zd", httpResponse.statusCode);
            }
        } else {
            NSLog(@"GetLoginToken error : %@", error.localizedDescription);
        }
    }];
    [task resume];
}

- (void) requestDesktopList {
    NSLog(@"requestDesktopList LoginToken=%@, SessionId=%@", self->mLoginToken, self->mSessionId);
    NSMutableString* params = [[NSMutableString alloc]init];
    
    NSString* action = @"DescribeDesktops";
    NSString* maxResult = @"100";
    NSString* protocolType = @"both";
    
    [params appendString:self->mBaseParams];
    [params appendFormat:@"&Action=%@", action];
    [params appendFormat:@"&LoginToken=%@", self->mLoginToken];
    [params appendFormat:@"&MaxResults=%@", maxResult];
    [params appendFormat:@"&ProtocolType=%@", protocolType];
    [params appendFormat:@"&SessionId=%@", self->mSessionId];
    
    NSString* requestUrl = [[NSString alloc] initWithFormat:@"%@%@", mUrl, params];
    requestUrl = [requestUrl stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet characterSetWithCharactersInString:@"#%<>[\\]^`{|}\"]+"].invertedSet];
    
    NSURL* url = [NSURL URLWithString:requestUrl];
    NSURLRequest* request = [[NSURLRequest alloc]initWithURL:url];
    
    NSURLSession* session = [NSURLSession sharedSession];
    NSURLSessionDataTask* task = [session dataTaskWithRequest:request completionHandler:
        ^(NSData* data, NSURLResponse* response, NSError* error){
        NSLog(@"获取云桌面列表请求完成");
        if(!error) {
            NSHTTPURLResponse* httpResponse = (NSHTTPURLResponse*) response;
            NSLog(@"statusCode:%zd", httpResponse.statusCode); //200 if success
            if (httpResponse.statusCode == 200) {
                NSDictionary *resDict = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingFragmentsAllowed error:nil];
                for (NSString *key in resDict) {
                    id value = resDict[key];
                    NSLog(@"%@:%@", key, value);
                }
                NSMutableArray* desktops = [self parseDesktopList:resDict];
                
                //open desktop list view
                dispatch_async(dispatch_get_main_queue(),  ^{
                    UIStoryboard* storyboard = self.storyboard;
                    DesktopListViewController* listViewController = [storyboard instantiateViewControllerWithIdentifier:@"listvc"];
                    listViewController.modalPresentationStyle = UIModalPresentationFullScreen;
                    listViewController.desktopList = desktops;
                    [listViewController initRequestParamWithUrl:self->mUrl baseParams:self->mBaseParams sessionId:self->mSessionId loginToken:self->mLoginToken];
                    [self presentViewController:listViewController animated:TRUE completion:nil];
                });
            } else {
                NSLog(@"requestDesktopList statusCode error:%zd", httpResponse.statusCode);
            }
        } else {
            NSLog(@"error : %@", error.localizedDescription);
        }
    }];
    [task resume];
}

- (IBAction)onClickLoginBtn:(id)sender {
    UserInfo* userInfo = [[UserInfo alloc]init];
    userInfo.region = [self.region text];
    userInfo.workspaceId = [self.workspaceId text];
    userInfo.userName = [self.userName text];
    userInfo.userPwd = [self.userPwd text];
    
    // TODO check input param legality
    
    [self getDesktopList:userInfo];
    
    NSLog(@"onClickLoginBtn end");
    
}

- (void)requestNetwork{
    NSLog(@"requestNetwork");
    NSURL *url = [NSURL URLWithString:@"http://www.baidu.com"];
    NSURLRequest *request = [NSURLRequest requestWithURL:url];
    [NSURLConnection sendAsynchronousRequest:request queue:[NSOperationQueue mainQueue] completionHandler:^(NSURLResponse * _Nullable response, NSData * _Nullable data, NSError * _Nullable connectionError) {
    }];
}

@end
