//
//  DesktopListViewController.m
//  aspdemo
//
//  Created by 杨航涛 on 2021/11/27.
//

#import "DesktopListViewController.h"
#import "AccountHelper.h"

#import "DesktopAddViewController.h"

// TicketInfo
typedef struct {
    NSString* desktopId;
    NSString* taskId;
    NSString* ticket;
    int count;
} TicketInfo;

@interface GatewayInfo : NSObject
@property NSString* gwToken;
@property int forceTlsType;
@property NSString* gatewayAddress;
@property NSString* gatewayDomainAddress;
@property NSString* gatewayPort;
@property NSString* gatewayWssPort;
@end

@implementation GatewayInfo
@end

#pragma mark --DesktopListViewController定义
@interface DesktopListViewController () {
    NSString* mUrl;
    NSString* mBaseParams;
    NSString* mSessionId;
    NSString* mLoginToken;
    TicketInfo mTicketInfo;
    BOOL mIsConnectioning;
}

@property NSString* innerPropParam;

-(void)getConnectionTicketWithDesktopId:(NSString*) desktopId
                                 taskId:(NSString*) taskId
                         recursiveCount:(int) count;

-(GatewayInfo*) parseTicket:(NSString*) ticket;

@end


#pragma mark --DesktopListViewController实现
@implementation DesktopListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    NSLog(@"DesktopListViewController viewDidLoad");
    for (CloudDesktop* desktop in self.desktopList) {
        NSLog(@"name:%@", desktop.desktopName);
    }
}

-(void) initRequestParamWithUrl:(NSString*)url
                     baseParams:(NSString*)baseParams
                      sessionId:(NSString*)sessionId
                     loginToken:(NSString*)loginToken {
    self->mUrl = url;
    self->mBaseParams = baseParams;
    self->mSessionId = sessionId;
    self->mLoginToken = loginToken;
    self->mTicketInfo.taskId = @"";
    self->mTicketInfo.ticket = @"";
    self->mTicketInfo.count = 1;
}

#pragma mark --UITableViewDataSource 协议方法
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [self.desktopList count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell* cell = [tableView dequeueReusableCellWithIdentifier:@"CellIdentifier" forIndexPath:indexPath];
    NSUInteger row = [indexPath row];
    
    CloudDesktop* desktop = self.desktopList[row];
    cell.textLabel.text = desktop.desktopName;
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    return cell;
}

#pragma mark --UITableViewDelegate 协议方法
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    if (mIsConnectioning) {
        return;
    }
    mIsConnectioning = YES;
    NSUInteger row = [indexPath row];
    NSLog(@"didSelectRowAtIndexPath:%lu", row);
    CloudDesktop* desktop = self.desktopList[row];
    self->mTicketInfo.desktopId = desktop.desktopId;
    [self getConnectionTicketWithDesktopId:self->mTicketInfo.desktopId taskId:@"" recursiveCount:self->mTicketInfo.count];
}

-(void)getConnectionTicketWithDesktopId:(NSString*) desktopId
                                 taskId:(NSString*) taskId
                         recursiveCount:(int) count {
    NSLog(@"getConnectionTicketWithDesktopId desktopId=%@, taskId=%@, count=%d", desktopId, taskId, count);
    NSMutableString* params = [[NSMutableString alloc]init];
    NSString* action = @"GetConnectionTicket";
    [params appendString:self->mBaseParams];
    [params appendFormat:@"&Action=%@", action];
    [params appendFormat:@"&LoginToken=%@", self->mLoginToken];
    [params appendFormat:@"&DesktopId=%@", desktopId];
    [params appendFormat:@"&SessionId=%@", self->mSessionId];
    [params appendFormat:@"&TaskId=%@", taskId];
    NSString* requestUrl = [[NSString alloc]initWithFormat:@"%@%@", mUrl, params];
    requestUrl = [requestUrl stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet characterSetWithCharactersInString:@"#%<>[\\]^`{|}\"]+"].invertedSet];
    NSLog(@"requestUrl=%@", requestUrl);
    NSURL* url = [NSURL URLWithString:requestUrl];
    NSURLRequest* request = [[NSURLRequest alloc]initWithURL:url];
    
    NSURLSession* session = [NSURLSession sharedSession];
    NSURLSessionDataTask* task = [session dataTaskWithRequest:request completionHandler:
        ^(NSData* data, NSURLResponse* response, NSError* error){
        NSLog(@"获取云桌面ticket请求完成");
        mIsConnectioning = NO;
        if(!error) {
            NSHTTPURLResponse* httpResponse = (NSHTTPURLResponse*) response;
            NSLog(@"statusCode:%zd", httpResponse.statusCode); //200
            if (httpResponse.statusCode == 200) {
                NSDictionary *resDict = [NSJSONSerialization JSONObjectWithData:data options:NSJSONReadingFragmentsAllowed error:nil];
                for (NSString *key in resDict) {
                    id value = resDict[key];
                    NSLog(@"%@:%@", key, value);
                }
                NSString* taskStatus = resDict[@"TaskStatus"];
                self->mTicketInfo.taskId = resDict[@"TaskId"];
                if (![taskStatus isEqualToString:@"FINISHED"]) {
                    self->mTicketInfo.count ++;
                    NSLog(@"desktopId:%@, taskId:%@, count:%d", self->mTicketInfo.desktopId, self->mTicketInfo.taskId, self->mTicketInfo.count);
                    [self getConnectionTicketWithDesktopId:self->mTicketInfo.desktopId taskId:self->mTicketInfo.taskId recursiveCount:self->mTicketInfo.count];
                } else {
                    NSString* ticket = resDict[@"Ticket"];
                    DesktopConnParam* connParam = [[DesktopConnParam alloc]init];
                    connParam.desktopId = self->mTicketInfo.desktopId;
#if 0 //0 0r 1
                    //use ip/port
                    GatewayInfo* gwInfo = [self parseTicket:ticket];
                    NSLog(@"ip:%@, port:%@, token:%@",gwInfo.gatewayAddress, gwInfo.gatewayPort, gwInfo.gwToken);
                    connParam.connIp = gwInfo.gatewayAddress;
                    connParam.connPort = gwInfo.gatewayPort;
                    connParam.connUdpPort = gwInfo.gatewayPort; //TODO: +1
                    connParam.connToken = gwInfo.gwToken;
#else
                    //use ticket
                    connParam.connTicket = ticket;
#endif
                    connParam.enableTls = true;
                    dispatch_async(dispatch_get_main_queue(),  ^{
                        UIStoryboard* storyboard = self.storyboard;
                        // use StreamView
                        DesktopAddViewController* addViewController =  [storyboard instantiateViewControllerWithIdentifier:@"addvc"];
                        addViewController.modalPresentationStyle = UIModalPresentationFullScreen;
                        addViewController.connParam = connParam;
                        [self presentViewController:addViewController animated:TRUE completion:nil];
                    });
                    
                }
            } else {
                NSLog(@"request error");
                [self dismissViewController];
            }
        } else {
            NSLog(@"error : %@", error.localizedDescription);
            [self dismissViewController];
        }
    }];
    [task resume];
    count ++;
}

- (void)dismissViewController {
    __weak typeof(self) weakSelf = self;
    dispatch_async(dispatch_get_main_queue(), ^{
        [weakSelf dismissViewControllerAnimated:YES completion:nil];
    });
}

-(GatewayInfo*) parseTicket:(NSString*) ticket {
    GatewayInfo* gwInfo = [[GatewayInfo alloc]init];
    NSData* data = [[NSData alloc]initWithBase64EncodedString:ticket options:0];
    NSString* decodeStr = [[NSString alloc]initWithData:data encoding:NSUTF8StringEncoding];
    NSLog(@"parseTicket decodeStr:%@", decodeStr);
    
    NSArray* array = [decodeStr componentsSeparatedByString:@"\r\n"];
    for (NSString* str in array) {
        NSRange GWTokenRange = [str rangeOfString:@"GWToken="];
        NSRange GatewayAddressRange = [str rangeOfString:@"GatewayAddress="];
        NSRange GatewayPortRange = [str rangeOfString:@"GatewayPort="];
        if (GWTokenRange.location != NSNotFound) {
            gwInfo.gwToken = [str substringFromIndex:(GWTokenRange.length)];
        } else if (GatewayAddressRange.location != NSNotFound) {
            gwInfo.gatewayAddress = [str substringFromIndex:(GatewayAddressRange.length)];
        } else if (GatewayPortRange.location != NSNotFound) {
            gwInfo.gatewayPort = [str substringFromIndex:(GatewayPortRange.length)];
        }
    }
    return gwInfo;
}



/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
