//
//  DebugToolManager.m
//  aspdemo
//
//  Created by wenzhang on 2022/2/14.
//

#import "DebugToolManager.h"
#include <objc/message.h>
#include <objc/runtime.h>

@interface DebugToolManager ()<UITableViewDelegate, UITableViewDataSource>

@property (nonatomic, weak  ) UIView *contentView;
@property (nonatomic, assign) BOOL isOpen;
@property (nonatomic, strong) NSMutableArray *subViewsList;
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSArray *tableDataList;
@property (nonatomic, strong) UILabel *loadingView;

@property (nonatomic, strong) id keyboard;

@end

@implementation DebugToolManager

- (void)loadDebugView:(UIView *)contentView streamView:(UIView *)streamView {
    [self clearSubViews];
    self.subViewsList = [[NSMutableArray alloc] init];
    self.contentView = contentView;
    [self loadRootButton];
    
    Class cls = NSClassFromString(@"ASPKeyboard");
    self.keyboard = [[cls alloc] init];
    [self setKeyboardDelegate:self];
    [self setStreamView:streamView];
}

- (void)dealloc {
    [self setKeyboardDelegate:nil];
}

#pragma mark - action

- (void)openRootView {
    [self doRootAction:self.rootButton];
}

- (void)doRootAction:(UIButton *)sender {
    if (!self.isOpen) {
        self.isOpen = YES;
        [self loadBgView];
        [self loadSubViews];
    } else {
        self.isOpen = NO;
        [self clearSubViews];
    }
}

- (void)doKeyBoardAction:(UIButton *)sender {
    if ([self isShowKeyboard]) {
        [self hideKeyboard];
    } else {
        [self showKeyboard];
    }
}

- (void)setKeyboardDelegate:(id)target {
    SEL sel = NSSelectorFromString(@"setDelegate:");
    if ([self.keyboard respondsToSelector:sel]) {
        ((void(*)(id, SEL, id))objc_msgSend)(self.keyboard, sel, target);
    }
}

- (void)setStreamView:(id)target {
    SEL sel = NSSelectorFromString(@"setStreamView:");
    if ([self.keyboard respondsToSelector:sel]) {
        ((void(*)(id, SEL, id))objc_msgSend)(self.keyboard, sel, target);
    }
}

- (BOOL)isShowKeyboard {
    BOOL isShow = NO;
    SEL sel = NSSelectorFromString(@"isShow");
    if ([self.keyboard respondsToSelector:sel]) {
        isShow = ((BOOL(*)(id, SEL))objc_msgSend)(self.keyboard, sel);
    }
    return isShow;
}

- (void)showKeyboard {
    SEL sel = NSSelectorFromString(@"show");
    if ([self.keyboard respondsToSelector:sel]) {
        ((void(*)(id, SEL))objc_msgSend)(self.keyboard, sel);
    }
}

- (void)hideKeyboard {
    SEL sel = NSSelectorFromString(@"hide");
    if ([self.keyboard respondsToSelector:sel]) {
        ((void(*)(id, SEL))objc_msgSend)(self.keyboard, sel);
    }
}

- (void)doSimulateMouseAction:(UIButton *)sender {
    if ([self.delegate respondsToSelector:@selector(onClickSimulateMouse)]) {
        [self.delegate onClickSimulateMouse];
    }
}

- (void)doMoreAction:(UIButton *)sender {
    if (self.tableView) {
        [self clearTableView];
        return;
    }
    self.tableDataList = @[@{@"title": @"触控/鼠标模式切换", @"actionName":@"doEnableMouseMode"},
                           @{@"title": @"断开连接", @"actionName": @"doDisconnectingAction"},
                           @{@"title": @"切换分辨率", @"actionName": @"doChangeResolutionRatioAction"},
                           @{@"title": @"静音", @"actionName": @"doMuteAction"},
                           @{@"title": @"云端touch", @"actionName": @"doTouchAction"},
                           @{@"title": @"桌面手势", @"actionName": @"doGestureAction"},
                           @{@"title": @"超分", @"actionName": @"doSuperResolutionAction"},
                           @{@"title": @"触感反馈", @"actionName": @"doTouchFeelAction"},
    ];
    CGFloat rowHeight = 44;
    CGFloat x = sender.frame.origin.x;
    CGFloat y = CGRectGetMaxY(sender.frame) + 5;
    CGRect frame = CGRectMake(x, y, 160, self.tableDataList.count * rowHeight);
    self.tableView = [[UITableView alloc] initWithFrame:frame style:UITableViewStylePlain];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.layer.cornerRadius = 6;
    self.tableView.clipsToBounds = YES;
    self.tableView.backgroundColor = [UIColor colorWithWhite:0 alpha:0.45];
    [self.contentView addSubview:self.tableView];
    
    [self.tableView reloadData];
    
    [self.subViewsList addObject:self.tableView];
}

- (void)doTapAction:(UITapGestureRecognizer *)ges {
    self.isOpen = NO;
    [self clearSubViews];
}

- (void)clearSubViews {
    self.isOpen = NO;
    for (UIView *subView in self.subViewsList) {
        [subView removeFromSuperview];
    }
    [self.subViewsList removeAllObjects];
    [self clearTableView];
    [self clearTextField];
}

- (void)clearTableView {
    if (self.tableView) {
        self.tableView.delegate = nil;
        self.tableView.dataSource = nil;
        [self.tableView removeFromSuperview];
        self.tableView = nil;
    }
}

- (void)clearTextField {
    [self hideKeyboard];
}

- (void)doTouchAction {
    [self clearSubViews];
    
    if ([self.delegate respondsToSelector:@selector(doTouchAction)]) {
        [self.delegate doTouchAction];
    }
}

- (void)doGestureAction {
    [self clearSubViews];
    
    if ([self.delegate respondsToSelector:@selector(doGestureAction)]) {
        [self.delegate doGestureAction];
    }
}

- (void)doSuperResolutionAction {
    [self clearSubViews];
    
    if ([self.delegate respondsToSelector:@selector(doSuperResolutionAction)]) {
        [self.delegate doSuperResolutionAction];
    }
}

- (void)doMuteAction {
    [self clearSubViews];
    
    if ([self.delegate respondsToSelector:@selector(onMuteAction)]) {
        [self.delegate onMuteAction];
    }
}

- (void)doChangeResolutionRatioAction {
    [self clearSubViews];
    
    if ([self.delegate respondsToSelector:@selector(onChangeResolutionRatioListAction)]) {
        [self.delegate onChangeResolutionRatioListAction];
    }
}

- (void)doEnableMouseMode {
    [self clearSubViews];
    if ([self.delegate respondsToSelector:@selector(onEnableMouseModeAction)]) {
        [self.delegate onEnableMouseModeAction];
    }
}

- (void)doDisconnectingAction {
    [self clearSubViews];
    
    if ([self.delegate respondsToSelector:@selector(onDisconnectingAction)]) {
        [self.delegate onDisconnectingAction];
    }
}

- (void)doTouchFeelAction {
    [self clearSubViews];
    
    if ([self.delegate respondsToSelector:@selector(onTouchFeelAction)]) {
        [self.delegate onTouchFeelAction];
    }
}

#pragma mark - loadView

- (void)loadRootButton {
    CGSize size = [self sizeOfButton];
    NSString *sizeString = NSStringFromCGSize(size);
    NSDictionary *infoDic = @{@"imageName": @"float_view",
                              @"actionName": NSStringFromSelector(@selector(doRootAction:)),
                              @"sizeString": sizeString};
    CGFloat off = [self offOfSubViews];
    CGFloat x = [UIScreen mainScreen].bounds.size.width/2.0 - size.width/2.0;
    CGFloat y = off;
    UIButton *button = [self createButton:infoDic];
    button.frame = CGRectMake(x, y, size.width, size.height);
    [[self contentView] addSubview:button];
    
    if (@available(iOS 13.0, *)) {
        UIHoverGestureRecognizer* hoverRecognizer = [[UIHoverGestureRecognizer alloc] initWithTarget:self action:@selector(handleHover:)];
        [button addGestureRecognizer:hoverRecognizer];
    }
    
    self.rootButton = button;
}

- (void)handleHover:(UIHoverGestureRecognizer*) sender  API_AVAILABLE(ios(13.0)) {
    CGPoint locationPoint = [sender locationInView:sender.view];
    UIGestureRecognizerState state = sender.state;
    if (state == UIGestureRecognizerStateBegan) {
        if ([self.delegate respondsToSelector:@selector(onSetCursorShow:)]) {
            [self.delegate onSetCursorShow:NO];
        }
    } else if (state == UIGestureRecognizerStateEnded || state == UIGestureRecognizerStateCancelled || state == UIGestureRecognizerStateFailed) {
        if ([self.delegate respondsToSelector:@selector(onSetCursorShow:)]) {
            [self.delegate onSetCursorShow:YES];
        }
    }
}

- (void)loadBgView {
    UIView *bgView = [[UIView alloc] initWithFrame:self.contentView.bounds];
    bgView.backgroundColor = [UIColor colorWithWhite:0 alpha:0.25];
    [[self contentView] insertSubview:bgView belowSubview:self.rootButton];
    
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(doTapAction:)];
    [bgView addGestureRecognizer:tap];
    
    [self.subViewsList addObject:bgView];
}

- (void)loadSubViews {
    CGSize size = [self sizeOfButton];
    NSString *sizeString = NSStringFromCGSize(size);
    NSArray *list = @[@{@"imageName": @"",
                        @"title": @"键盘",
                        @"actionName": NSStringFromSelector(@selector(doKeyBoardAction:)),
                        @"sizeString": sizeString},
                      @{@"imageName": @"",
                        @"title": @"点击",
                        @"actionName": NSStringFromSelector(@selector(doSimulateMouseAction:)),
                        @"sizeString": sizeString},
                      @{@"imageName": @"",
                        @"title": @"更多",
                        @"actionName": NSStringFromSelector(@selector(doMoreAction:)),
                        @"sizeString": sizeString}
    ];
    CGFloat off = [self offOfSubViews];
    CGFloat x = [UIScreen mainScreen].bounds.size.width/2.0 + size.width/2.0 + off;
    CGFloat y = off;
    for (NSDictionary *infoDic in list) {
        UIButton *button = [self createButton:infoDic];
        button.frame = CGRectMake(x, y, size.width, size.height);
        x = x + size.width + off;
        [[self contentView] addSubview:button];
        
        [self.subViewsList addObject:button];
    }
}

- (CGSize)sizeOfButton {
    return CGSizeMake(44, 44);
}

- (CGFloat)offOfSubViews {
    return 10;
}

- (UIButton *)createButton:(NSDictionary *)infoDic {
    NSString *imageName = [infoDic objectForKey:@"imageName"];
    NSString *actionName = [infoDic objectForKey:@"actionName"];
    NSString *sizeString = [infoDic objectForKey:@"sizeString"];
    NSString *title = [infoDic objectForKey:@"title"];
    
    UIButton *button = [[UIButton alloc] init];
    button.backgroundColor = [UIColor colorWithWhite:0 alpha:0.45];
    
    SEL actionSel = NSSelectorFromString(actionName);
    if (actionSel) {
        [button addTarget:self action:actionSel forControlEvents:UIControlEventTouchUpInside];
    }
    
    UIImage *image = [UIImage imageNamed:imageName];
    [button setImage:image forState:UIControlStateNormal];
    
    if (title.length) {
        [button setTitle:title forState:UIControlStateNormal];
        button.titleLabel.font = [UIFont systemFontOfSize:12];
    }
    
    CGSize size = CGSizeFromString(sizeString);
    button.frame = CGRectMake(0, 0, size.width, size.height);
    
    button.layer.cornerRadius = size.width/2.0;
    button.clipsToBounds = YES;
    
    return button;
}

#pragma mark - tableview delegate

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.tableDataList.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 44.0;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cell_id = @"debug_cell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cell_id];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cell_id];
    }
    NSDictionary *dataDic = [self.tableDataList objectAtIndex:indexPath.row];
    NSString *title = [dataDic objectForKey:@"title"];
    cell.textLabel.text = title;
    cell.textLabel.font = [UIFont systemFontOfSize:12];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    NSDictionary *dataDic = [self.tableDataList objectAtIndex:indexPath.row];
    NSString *actionName = [dataDic objectForKey:@"actionName"];
    SEL actionSel = NSSelectorFromString(actionName);
    if (actionSel && [self respondsToSelector:actionSel]) {
        [self performSelector:actionSel];
    }
}

#pragma mark - ASPKeyboardDelegate
- (void)onSendKeyboardEvent:(ASPKeyEvent)event {
    if ([self.delegate respondsToSelector:@selector(onSendKeyboardEvent:)]) {
        [self.delegate onSendKeyboardEvent:event];
    }
}

- (void)showLoading:(NSString *)msg {
    dispatch_async(dispatch_get_main_queue(), ^{
        [self m_showLoading:msg];
    });
}

- (void)m_showLoading:(NSString *)msg {
    if (!self.loadingView) {
        self.loadingView = [[UILabel alloc] init];
        self.loadingView.backgroundColor = [UIColor colorWithWhite:0 alpha:0.25];
        self.loadingView.font = [UIFont systemFontOfSize:30];
        self.loadingView.textColor = [UIColor whiteColor];
        self.loadingView.textAlignment = NSTextAlignmentCenter;
        self.loadingView.frame = [UIApplication sharedApplication].keyWindow.bounds;
        [[UIApplication sharedApplication].keyWindow addSubview:self.loadingView];
    }
    self.loadingView.text = msg;
}

- (void)hideLoading {
    dispatch_async(dispatch_get_main_queue(), ^{
        [self m_hideLoading];
    });
}
- (void)m_hideLoading {
    [self.loadingView removeFromSuperview];
    self.loadingView = nil;
}

@end
