//
//  DebugToolManager.h
//  aspdemo
//
//  Created by wenzhang on 2022/2/14.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <ASPEngineSDK/ASPEngineSDK.h>

NS_ASSUME_NONNULL_BEGIN

@protocol DebugToolManagerDelegate <NSObject>

- (void)doSuperResolutionAction;
- (void)doGestureAction;
- (void)doTouchAction;
- (void)onMuteAction;
- (void)onChangeResolutionRatioListAction;
- (void)onEnableMouseModeAction;
- (void)onDisconnectingAction;
- (void)onClickSimulateMouse;
- (void)onSendKeyboardEvent:(ASPKeyEvent)event;
- (void)onSetCursorShow:(BOOL)show;
- (void)onTouchFeelAction;

@end

@interface DebugToolManager : NSObject

@property (nonatomic, weak) id<DebugToolManagerDelegate> delegate;

- (void)loadDebugView:(UIView *)contentView streamView:(UIView *)streamView;

@property (nonatomic, strong) UIButton *rootButton;

- (void)showLoading:(NSString *)msg;
- (void)hideLoading;
- (void)openRootView;

@end

NS_ASSUME_NONNULL_END
